# Web Experience Toolkit (WET)

[![Build Status](https://secure.travis-ci.org/wet-boew/wet-boew.png?branch=master)](http://travis-ci.org/wet-boew/wet-boew)

* **WET v3.1.0 Beta 2 was released on February 15, 2013** ([v3.1.0 Beta 2 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-Beta-2-release-notes))
* **WET v3.0.5 was released on February 15, 2013** ([v3.0.5 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.5-release-notes))
* **WET v3.0.4 was released on January 24, 2013** ([v3.0.4 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.4-release-notes))
* **WET v3.1.0 Beta 1 was released on December 21, 2012** ([v3.1.0 Beta 1 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-Beta-1-release-notes))
* **WET v3.0.3 was released on December 21, 2012** ([v3.0.3 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.3-release-notes))
* **WET v3.0.2 was released on November 15, 2012** ([v3.0.2 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.2-release-notes))
* **WET v3.0.1 was released on October 9, 2012** ([v3.0.1 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.1-release-notes))
* **WET v3.0 was released on September 17, 2012** ([v3.0 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0-release-notes))

Web Experience Toolkit (WET) includes reusable components for building and maintaining innovative Web sites that are accessible, usable, and interoperable. These reusable components are open source software and free for use by departments and external Web communities.  

The toolkit complies with the new Standards on Web Accessibility and Web Usability; the toolkit will also ease compliance with the Standard on Web Interoperability. WET is highly recommended for use on Government of Canada Websites.

## Benefits

* Provides reusable components for building and maintaining innovative Web sites.
* Respects accessibility ([WCAG 2.0](http://www.w3.org/TR/WCAG20/) AA and [WAI-ARIA](http://www.w3.org/TR/wai-aria/)), usability, and interoperability.
* Reduces costs by consolidating Web tools and solutions.
* Open source software that is free to use by departments and external Web communities.
* Uses advanced technologies to push the envelope for Web site functionality:
  * [HTML5](http://www.w3.org/TR/html5/), [CSS3](http://www.w3.org/Style/CSS/current-work), [jQuery](http://jquery.com/) (JavaScript framework);
  * Ever-growing list of open source plugins and widgets.
* Supports a wide range of layouts and designs for internal and external Web sites (including applications).

## Key resources

* [Working examples](http://wet-boew.github.com/wet-boew/demos/index-eng.html)
* [Documentation](https://github.com/wet-boew/wet-boew/wiki#wiki-Documentation)
* [Downloads](https://github.com/wet-boew/wet-boew/wiki/Downloads)
* [Terms and conditions](http://wet-boew.github.com/wet-boew/License-eng.txt)
* [Contributor guidelines](https://github.com/wet-boew/wet-boew/wiki/Developing-for-WET#wiki-Contributor_guidelines)
* [Roadmap](https://github.com/wet-boew/wet-boew/wiki/Roadmap)

-------------------------------------------------------------------


# Boîte à outils de l’expérience Web (BOEW)

* **La version v3.1.0 Bêta 2 de la BOEW a été lancée le 15 février 2013** ([v3.1.0 Bêta 2 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-Beta-2-release-notes))
* **La version v3.0.5 de la BOEW a été lancée le 15 février 2013** ([v3.0.5 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.5-release-notes))
* **La version v3.0.4 de la BOEW a été lancée le 24 janvier 2013** ([v3.0.4 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.4-release-notes))
* **La version v3.1.0 Bêta 1 de la BOEW a été lancée le 21 décembre 2012** ([v3.1.0 Bêta 1 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-Beta-1-release-notes))
* **La version v3.0.3 de la BOEW a été lancée le 21 décembre 2012** ([v3.0.3 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.3-release-notes))
* **La version v3.0.2 de la BOEW a été lancée le 15 novembre 2012** ([v3.0.2 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.2-release-notes))
* **La version v3.0.1 de la BOEW a été lancée le 9 octobre 2012** ([v3.0.1 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.1-release-notes))
* **La version v3.0 de la BOEW a été lancée le 17 septembre 2012** ([v3.0 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0-release-notes))



## Vue d'ensemble

La Boîte à outils de l’expérience Web (BOEW) rassemble différents composants réutilisables et prêts-à-utiliser pour la conception et la mise à jour de sites Web innovateurs qui sont à la fois accessibles, conviviaux et interopérables. Tous ces composants réutilisables sont des logiciels libres mis à la disposition des ministères et des collectivités Web externes. 

La Boîte à outils est conforme à la Norme sur l'accessibilité des sites Web et la Norme sur la facilité des sites Web et sera conforme à la Norme sur l’interopérabilité du Web. Il est fortement recommandé d’utiliser la BOEW pour tous les sites Web du gouvernement du Canada.

## Avantages

* Fournit composants réutilisables pour la conception et la mise à jour de sites Web innovateurs.
* Respecte l'accessibilité ([WCAG 2.0](http://www.w3.org/Translations/WCAG20-fr) AA et [WAI-ARIA](http://www.w3.org/TR/wai-aria/)), la facilité d’emploi et l'interopérabilité.
* Réduit les coûts en consolidant les outils et solutions axés sur le Web. 
* Sont des logiciels libres mis à la disposition des ministères et des collectivités Web externes.
* Fait appel à des technologies nouvelles et novatrices pour rendre les sites plus novateurs et interactifs :
  * [HTML5](http://www.w3.org/TR/html5/), [CSS3](http://www.w3.org/Style/CSS/current-work#CSS3) et [jQuery](http://jquery.com/) (cadre JavaScript); 
  * liste croissante de plugiciels et gadgets de source ouverte.
* Permet d’avoir accès à une grande diversité de mises en page et de conceptions pour les sites Web internes et externes (y compris les applications). 

## Ressources clés

* [Exemples pratiques](http://wet-boew.github.com/wet-boew/demos/index-fra.html)
* [Documentation](https://github.com/wet-boew/wet-boew/wiki/Accueil#wiki-Documentation)
* [Versions à télécharger](https://github.com/wet-boew/wet-boew/wiki/Versions-de-t%C3%A9l%C3%A9chargement)
* [Conditions régissant l'utilisation](http://wet-boew.github.com/wet-boew/Licence-fra.txt)
* [Lignes directrices pour les contributeurs](https://github.com/wet-boew/wet-boew/wiki/Développer-pour-la-boew#wiki-Lignes_directrices_pour_les_contributeurs)
* [Feuille de route](https://github.com/wet-boew/wet-boew/wiki/Feuille-de-route)