# Web Experience Toolkit (WET)

[![Build Status](https://secure.travis-ci.org/wet-boew/wet-boew.png?branch=master)](http://travis-ci.org/wet-boew/wet-boew)

## What is the Web Experience Toolkit?

* Collaborative open source project led by the Government of Canada
* [Award-winning](https://github.com/wet-boew/wet-boew/wiki/Accolades#wiki-Awards) code library for building innovative websites that are:
 * [Accessible](#accessibility), [usable](#usability) and [interoperable](#interoperability)
 * [Mobile friendly](#mobile-friendly-responsive-design)
 * [Multilingual](#multilingual)
* [Flexible and themeable templates and reusable components](#themeable-and-reusable)
* Open source software
 * Free to use for commercial and non-commercial purposes (MIT license - [Terms and conditions](http://wet-boew.github.io/wet-boew/License-en.html))
 * [Developed openly by the community on GitHub](#collaborative-approach)

## Key resources
 
* [Benefits](#benefits)
* [Working examples](http://wet-boew.github.io/wet-boew/demos/index-en.html)
* [Working examples - v4.0](http://wet-boew.github.io/v4.0-ci/demos/index-en.html)
* [Documentation](https://github.com/wet-boew/wet-boew/wiki#wiki-Documentation)
* [Downloads](https://github.com/wet-boew/wet-boew/wiki/Downloads)
* [Main project](https://github.com/wet-boew/wet-boew/)
* [Terms and conditions](http://wet-boew.github.io/wet-boew/License-en.html)
* [Contributor guidelines](https://github.com/wet-boew/wet-boew/wiki/Contributor-guidelines)
* [Versioning](https://github.com/wet-boew/wet-boew/wiki/Versioning)
* [Version history](#version-history)
* [Roadmap](https://github.com/wet-boew/wet-boew/wiki/Roadmap)

## Benefits

### Accessibility 

* Conforms to [WCAG 2.0](http://www.w3.org/TR/WCAG20/) level AA
* Leverages [WAI-ARIA](http://www.w3.org/TR/wai-aria/) to further enhance accessibility
* Assistive technology testing (Access Working Group)

### Usability

* Iterative approach to design
* Design patterns and usability testing (User Experience Working Group)

### Interoperability

* [HTML5](http://www.w3.org/TR/html5/)-first approach (leveraging native HTML5 support and filling support gaps with “polyfills”)
* Supporting a wide variety of browsers (IE, Firefox, Chrome, Safari, Opera)
* Building support for HTML data ([RDFa 1.1 Lite](http://www.w3.org/TR/rdfa-lite/), [Schema.org](http://http://www.schema.org/))

### Mobile friendly responsive design

* Adapts to different screen sizes and device capabilities
* Touchscreen support ([jQuery Mobile](http://www.jquerymobile.com))
* Optimized for performance
* Building support for device-based mobile applications

### Multilingual

* Currently supports 33 languages (including right-to-left languages)
 * English
 * French
 * Afrikaans
 * Albanian
 * Arabic
 * Armenian
 * Bulgarian
 * Chinese
 * Chinese (Simplified)
 * Czech
 * Dutch
 * Estonian
 * German
 * Greek
 * Hindi
 * Hungarian
 * Icelandic
 * Indonesian
 * Italian
 * Japanese
 * Korean
 * Latvian
 * Lithuanian
 * Polish
 * Portuguese
 * Portuguese (Brazilian)
 * Russian
 * Slovak
 * Spanish
 * Thai
 * Turkish
 * Ukranian
 * Vietnamese

### Themeable and reusable

* Flexible framework that supports custom themes
* Includes support for 5 different themes including a “Base” theme to use as a template
* Reusable templates, plugins and widgets
* Adapted to various CMS and programming frameworks (Drupal, WordPress, SharePoint (in development), DotNetNuke (in development), PHP, SSI, Java/Maven)

### Reduces costs by openly sharing and collaborating

* Drives down research and development costs
* Avoids duplication of effort
* Produces better quality results

### Collaborative approach

* Project managed openly on GitHub, including discussion through the issues tracker
* Encouraging a free flow of ideas, dialogue and innovation including sharing of challenges and ideas
* External contributions welcome
 * Pull requests
 * Design patterns
 * Issues and suggestions
 * Documentation
 * Testing
* Multi-level review process for contributions to ensure code integrity (combination of automated and manual reviews)

## Version history

### v3.1

* [v3.1 changelog](https://github.com/wet-boew/wet-boew/wiki/v3.1-changelog)
* **WET v3.1.6 was released on November 1, 2013** ([v3.1.6 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.6-release-notes))
* **WET v3.1.5 was released on October 27, 2013** ([v3.1.5 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.5-release-notes))
* **WET v3.1.4 was released on September 17, 2013** ([v3.1.4 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.4-release-notes))
* **WET v3.1.3 was released on August 6, 2013** ([v3.1.3 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.3-release-notes))
* **WET v3.1.2 was released on June 27, 2013** ([v3.1.2 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.2-release-notes))
* **WET v3.1.1 was released on May 16, 2013** ([v3.1.1 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.1-release-notes))
* **WET v3.1.0 was released on April 11, 2013** ([v3.1.0 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-release-notes))
* **WET v3.1.0 Release Candidate 1 was released on April 3, 2013** ([v3.1.0 Release Candidate 1 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-Release-Candidate-1-release-notes))
* **WET v3.1.0 Beta 2 was released on February 15, 2013** ([v3.1.0 Beta 2 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-Beta-2-release-notes))
* **WET v3.1.0 Beta 1 was released on December 21, 2012** ([v3.1.0 Beta 1 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-Beta-1-release-notes))

### v3.0

* [v3.0 changelog](https://github.com/wet-boew/wet-boew/wiki/v3.0-changelog)
* **WET v3.0.11 was released on October 27, 2013** ([v3.0.11 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.11-release-notes))
* **WET v3.0.10 was released on September 17, 2013** ([v3.0.10 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.10-release-notes))
* **WET v3.0.9 was released on August 6, 2013** ([v3.0.9 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.9-release-notes))
* **WET v3.0.8 was released on June 27, 2013** ([v3.0.8 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.8-release-notes))
* **WET v3.0.7 was released on May 16, 2013** ([v3.0.7 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.7-release-notes))
* **WET v3.0.6 was released on April 11, 2013** ([v3.0.6 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.6-release-notes))
* **WET v3.0.5 was released on February 15, 2013** ([v3.0.5 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.5-release-notes))
* **WET v3.0.4 was released on January 24, 2013** ([v3.0.4 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.4-release-notes))
* **WET v3.0.3 was released on December 21, 2012** ([v3.0.3 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.3-release-notes))
* **WET v3.0.2 was released on November 15, 2012** ([v3.0.2 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.2-release-notes))
* **WET v3.0.1 was released on October 9, 2012** ([v3.0.1 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0.1-release-notes))
* **WET v3.0 was released on September 17, 2012** ([v3.0 release notes](https://github.com/wet-boew/wet-boew/wiki/v3.0-release-notes))

-------------------------------------------------------------------

# Boîte à outils de l’expérience Web (BOEW)

## Qu’est-ce que la Boîte à outils de l’expérience Web?

* Un projet à source ouverte collaboratif dirigé par le Gouvernement du Canada
* Une bibliothèque de code [primée](https://github.com/wet-boew/wet-boew/wiki/Distinctions#wiki-Primes) pour construire des sites Web innovants&#160;:
 * [Accessibles](#accessibilit), [faciles d'emploi](#facilit-demploi) et [interopérables](#interoprabilit)
 * [Optimisés pour les appareils mobiles](#conception-optimise-pour-les-appareils-mobiles-et-ractive)
 * [Multilingues](#multilingue)
* [Des modèles, ainsi que des composants réutilisables, qui sont flexibles et personnalisables](#personnalisable-et-rutilisable)
* Un logiciel libre
 * Libre d'utilisation à des fins commerciales et non commerciales (licence MIT - [Conditions régissant l'utilisation](http://wet-boew.github.io/wet-boew/Licence-fr.txt))
 * [Développé ouvertement sur GitHub par la communauté](#approche-collaborative)

## Ressources clés
 
* [Avantages](#avantages)
* [Exemples pratiques](http://wet-boew.github.io/wet-boew/demos/index-fr.html)
* [Exemples pratiques - v4.0](http://wet-boew.github.io/v4.0-ci/demos/index-fr.html)
* [Documentation](https://github.com/wet-boew/wet-boew/wiki/Accueil#wiki-Documentation)
* [Téléchargements](https://github.com/wet-boew/wet-boew/wiki/T%C3%A9l%C3%A9chargements)
* [Projet principal](https://github.com/wet-boew/wet-boew/)
* [Conditions régissant l'utilisation](http://wet-boew.github.io/wet-boew/Licence-fr.html)
* [Lignes directrices pour les contributeurs](https://github.com/wet-boew/wet-boew/wiki/Lignes-directrices-pour-les-contributeurs)
* [Contrôle des versions](https://github.com/wet-boew/wet-boew/wiki/Contr%C3%B4le-des-versions)
* [Historique des versions](#historique-des-versions)
* [Feuille de route](https://github.com/wet-boew/wet-boew/wiki/Feuille-de-route)

## Avantages

### Accessibilité

* •	Conforme aux [Règles pour l'accessibilité des contenus Web (WCAG) 2.0](http://www.w3.org/Translations/WCAG20-fr/) niveau AA
* S'appuie sur [WAI-ARIA](http://www.w3.org/TR/wai-aria/) pour améliorer l'accessibilité
* Vérification avec les technologies d'assistance (Groupe de travail sur l'accessibilité)

### Facilité d'emploi

* Approche itérative pour la conception
* Patrons de conception et les essais de facilité d'emploi (Groupe de travail sur l'expérience des utilisateurs)

### Interopérabilité

* Approche centrée sur le [HTML5](http://www.w3.org/TR/html5/) (s'appuyant sur le soutien HTML5 natif et puis les &laquo;correctifs&raquo; pour résoudre les problèmes de soutien)
* Soutien pour plusieurs navigateurs (IE, Firefox, Chrome, Safari, Opera)
* Soutien en développement pour les données HTML ([RDFa 1.1 Lite](http://www.w3.org/TR/rdfa-lite/), [Schema.org](http://http://www.schema.org/))

### Conception optimisée pour les appareils mobiles et réactive

* S'adapte à différentes tailles d'écran et capacités d'appareil
* Soutien pour les écrans tactiles ([jQuery Mobile](http://www.jquerymobile.com))
* Optimisé pour les performances
* Soutien en développement pour les applications s’installant sur un appareil mobile

### Multilingue

* Soutien actuellement 33 langues (y compris les langues droite-à-gauche)
 * Anglais
 * Français
 * Afrikaans
 * Albanais
 * Allemand
 * Arabe
 * Arménien
 * Bulgare
 * Chinois
 * Chinois (simplifiée)
 * Coréen
 * Espagnol
 * Estonien
 * Grec
 * Hindi
 * Hongrois
 * Indonésien
 * Islandais
 * Italien
 * Japonais
 * Letton
 * Lituanien
 * Néerlandais
 * Polonais
 * Portugais
 * Portugais (brésilien)
 * Russe
 * Slovaque
 * Tchèque
 * Thaï
 * Turc
 * Ukrainien
 * Vietnamien

### Personnalisable et réutilisable

* Cadre flexible qui supporte des thèmes personnalisés
* Soutien 5 thèmes différents, y compris un thème de base servant comme modèle
* Modèles, plugiciels et gadgets réutilisables
* Adapté aux différents systèmes de gestion de contenu et cadres de programmation (Drupal, WordPress, SharePoint (en développement), DotNetNuke (en développement), PHP, SSI, Java/Maven)

### Réduit les coûts en partageant et en collaborant ouvertement

* Réduit les coûts de recherche et de développement
* Évite la duplication des efforts
* Produit des résultats de meilleure qualité

### Approche collaborative

* Projet géré ouvertement sur GitHub, y compris les discussions à travers le système de suivi des questions
* Encourage la libre circulation des idées, du dialogue et de l'innovation, y compris le partage des défis et des idées
* Les contributions externes sont invités
 * Soumissions de code
 * Patrons de conception
 * Problèmes et suggestions
 * Documentation
 * Évaluations
* Processus d'examen sur plusieurs niveaux pour les contributions pour assurer l'intégrité du code (combinaison d'évaluations automatisées et manuelles)

## Historique des versions

### Version 3.1

* [ChangeLog de la version 3.1](https://github.com/wet-boew/wet-boew/wiki/v3.1-changelog)
* **La version 3.1.6 de la BOEW a été lancée le 1 novembre 2013** ([v3.1.6 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.6-release-notes))
* **La version 3.1.5 de la BOEW a été lancée le 27 octobre 2013** ([v3.1.5 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.5-release-notes))
* **La version 3.1.4 de la BOEW a été lancée le 17 septembre 2013** ([v3.1.4 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.4-release-notes))
* **La version 3.1.3 de la BOEW a été lancée le 6 août 2013** ([v3.1.3 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.3-release-notes))
* **La version 3.1.2 de la BOEW a été lancée le 27 juin 2013** ([v3.1.2 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.2-release-notes))
* **La version 3.1.1 de la BOEW a été lancée le 16 mai 2013** ([v3.1.1 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.1-release-notes))
* **La version 3.1.0 de la BOEW a été lancée le 11 avril 2013** ([v3.1.0 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-release-notes))
* **La version 3.1.0 Candidate 1 de la BOEW a été lancée le 3 avril 2013** ([v3.1.0 Candidate 1 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-Release-Candidate-1-release-notes))
* **La version 3.1.0 Bêta 2 de la BOEW a été lancée le 15 février 2013** ([v3.1.0 Bêta 2 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-Beta-2-release-notes))
* **La version 3.1.0 Bêta 1 de la BOEW a été lancée le 21 décembre 2012** ([v3.1.0 Bêta 1 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.1.0-Beta-1-release-notes))

### Version 3.0
* [ChangeLog de la version 3.0](https://github.com/wet-boew/wet-boew/wiki/v3.0-changelog)
* **La version 3.0.11 de la BOEW a été lancée le 27 octobre 2013** ([v3.0.11 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.11-release-notes))
* **La version 3.0.10 de la BOEW a été lancée le 17 septembre 2013** ([v3.0.10 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.10-release-notes))
* **La version 3.0.9 de la BOEW a été lancée le 6 août 2013** ([v3.0.9 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.9-release-notes))
* **La version 3.0.8 de la BOEW a été lancée le 27 juin 2013** ([v3.0.8 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.8-release-notes))
* **La version 3.0.7 de la BOEW a été lancée le 16 mai 2013** ([v3.0.7 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.7-release-notes))
* **La version 3.0.6 de la BOEW a été lancée le 11 avril 2013** ([v3.0.6 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.6-release-notes))
* **La version 3.0.5 de la BOEW a été lancée le 15 février 2013** ([v3.0.5 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.5-release-notes))
* **La version 3.0.4 de la BOEW a été lancée le 24 janvier 2013** ([v3.0.4 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.4-release-notes))
* **La version 3.0.3 de la BOEW a été lancée le 21 décembre 2012** ([v3.0.3 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.3-release-notes))
* **La version 3.0.2 de la BOEW a été lancée le 15 novembre 2012** ([v3.0.2 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.2-release-notes))
* **La version 3.0.1 de la BOEW a été lancée le 9 octobre 2012** ([v3.0.1 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0.1-release-notes))
* **La version 3.0.0 de la BOEW a été lancée le 17 septembre 2012** ([v3.0 - notes d'utilisation](https://github.com/wet-boew/wet-boew/wiki/v3.0-release-notes))
