/*!
  proj4js.js -- Javascript reprojection library. 
  
  Authors:		Mike Adair madairATdmsolutions.ca
				Richard Greenwood richATgreenwoodmap.com
				Didier Richard
				Stephen Irons
  License:		LGPL as per: http://www.gnu.org/copyleft/lesser.html 
				Note: This program is an almost direct port of the C library
				Proj4.
*/
Proj4js={defaultDatum:"WGS84",transform:function(e,b,a){if(!e.readyToUse||!b.readyToUse){this.reportError("Proj4js initialization for "+e.srsCode+" not yet complete");return a}if((e.srsProjNumber=="900913"&&b.datumCode!="WGS84")||(b.srsProjNumber=="900913"&&e.datumCode!="WGS84")){var d=Proj4js.WGS84;this.transform(e,d,a);e=d}if(e.projName=="longlat"){a.x*=Proj4js.common.D2R;a.y*=Proj4js.common.D2R}else{if(e.to_meter){a.x*=e.to_meter;a.y*=e.to_meter}e.inverse(a)}if(e.from_greenwich){a.x+=e.from_greenwich}a=this.datum_transform(e.datum,b.datum,a);if(b.from_greenwich){a.x-=b.from_greenwich}if(b.projName=="longlat"){a.x*=Proj4js.common.R2D;a.y*=Proj4js.common.R2D}else{b.forward(a);if(b.to_meter){a.x/=b.to_meter;a.y/=b.to_meter}}return a},datum_transform:function(d,b,a){if(d.compare_datums(b)){return a}if(d.datum_type==Proj4js.common.PJD_NODATUM||b.datum_type==Proj4js.common.PJD_NODATUM){return a}if(d.datum_type==Proj4js.common.PJD_GRIDSHIFT){alert("ERROR: Grid shift transformations are not implemented yet.")}if(b.datum_type==Proj4js.common.PJD_GRIDSHIFT){alert("ERROR: Grid shift transformations are not implemented yet.")}if(d.es!=b.es||d.a!=b.a||d.datum_type==Proj4js.common.PJD_3PARAM||d.datum_type==Proj4js.common.PJD_7PARAM||b.datum_type==Proj4js.common.PJD_3PARAM||b.datum_type==Proj4js.common.PJD_7PARAM){d.geodetic_to_geocentric(a);if(d.datum_type==Proj4js.common.PJD_3PARAM||d.datum_type==Proj4js.common.PJD_7PARAM){d.geocentric_to_wgs84(a)}if(b.datum_type==Proj4js.common.PJD_3PARAM||b.datum_type==Proj4js.common.PJD_7PARAM){b.geocentric_from_wgs84(a)}b.geocentric_to_geodetic(a)}if(b.datum_type==Proj4js.common.PJD_GRIDSHIFT){alert("ERROR: Grid shift transformations are not implemented yet.")}return a},reportError:function(a){},extend:function(a,e){a=a||{};if(e){for(var d in e){var b=e[d];if(b!==undefined){a[d]=b}}}return a},Class:function(){var b=function(){this.initialize.apply(this,arguments)};var a={};var e;for(var d=0;d<arguments.length;++d){if(typeof arguments[d]=="function"){e=arguments[d].prototype}else{e=arguments[d]}Proj4js.extend(a,e)}b.prototype=a;return b},bind:function(d,b){var a=Array.prototype.slice.apply(arguments,[2]);return function(){var e=a.concat(Array.prototype.slice.apply(arguments,[0]));return d.apply(b,e)}},scriptName:"proj4js.js",defsLookupService:"http://spatialreference.org/ref",libPath:null,getScriptLocation:function(){if(this.libPath){return this.libPath}var f=this.scriptName;var e=f.length;var a=document.getElementsByTagName("script");for(var d=0;d<a.length;d++){var g=a[d].getAttribute("src");if(g){var b=g.lastIndexOf(f);if((b>-1)&&(b+e==g.length)){this.libPath=g.slice(0,-e);break}}}return this.libPath||""},loadScript:function(e,f,d,a){var b=document.createElement("script");b.defer=false;b.type="text/javascript";b.id=e;b.src=e;b.onload=f;b.onerror=d;b.loadCheck=a;if(/MSIE/.test(navigator.userAgent)){b.onreadystatechange=this.checkReadyState}document.getElementsByTagName("head")[0].appendChild(b)},checkReadyState:function(){if(this.readyState=="loaded"){if(!this.loadCheck()){this.onerror()}else{this.onload()}}}};Proj4js.Proj=Proj4js.Class({readyToUse:false,title:null,projName:null,units:null,datum:null,initialize:function(a){this.srsCode=a.toUpperCase();if(this.srsCode.indexOf("EPSG")==0){this.srsCode=this.srsCode;this.srsAuth="epsg";this.srsProjNumber=this.srsCode.substring(5)}else{if(this.srsCode.indexOf("IGNF")==0){this.srsCode=this.srsCode;this.srsAuth="IGNF";this.srsProjNumber=this.srsCode.substring(5)}else{if(this.srsCode.indexOf("CRS")==0){this.srsCode=this.srsCode;this.srsAuth="CRS";this.srsProjNumber=this.srsCode.substring(4)}else{this.srsAuth="";this.srsProjNumber=this.srsCode}}}this.loadProjDefinition()},loadProjDefinition:function(){if(Proj4js.defs[this.srsCode]){this.defsLoaded();return}var a=Proj4js.getScriptLocation()+"defs/"+this.srsAuth.toUpperCase()+this.srsProjNumber+".js";Proj4js.loadScript(a,Proj4js.bind(this.defsLoaded,this),Proj4js.bind(this.loadFromService,this),Proj4js.bind(this.checkDefsLoaded,this))},loadFromService:function(){var a=Proj4js.defsLookupService+"/"+this.srsAuth+"/"+this.srsProjNumber+"/proj4js";Proj4js.loadScript(a,Proj4js.bind(this.defsLoaded,this),Proj4js.bind(this.defsFailed,this),Proj4js.bind(this.checkDefsLoaded,this))},defsLoaded:function(){this.parseDefs();this.loadProjCode(this.projName)},checkDefsLoaded:function(){if(Proj4js.defs[this.srsCode]){return true}else{return false}},defsFailed:function(){Proj4js.reportError("failed to load projection definition for: "+this.srsCode);Proj4js.extend(Proj4js.defs[this.srsCode],Proj4js.defs.WGS84);this.defsLoaded()},loadProjCode:function(b){if(Proj4js.Proj[b]){this.initTransforms();return}var a=Proj4js.getScriptLocation()+"projCode/"+b+".js";Proj4js.loadScript(a,Proj4js.bind(this.loadProjCodeSuccess,this,b),Proj4js.bind(this.loadProjCodeFailure,this,b),Proj4js.bind(this.checkCodeLoaded,this,b))},loadProjCodeSuccess:function(a){if(Proj4js.Proj[a].dependsOn){this.loadProjCode(Proj4js.Proj[a].dependsOn)}else{this.initTransforms()}},loadProjCodeFailure:function(a){Proj4js.reportError("failed to find projection file for: "+a)},checkCodeLoaded:function(a){if(Proj4js.Proj[a]){return true}else{return false}},initTransforms:function(){Proj4js.extend(this,Proj4js.Proj[this.projName]);this.init();this.readyToUse=true},parseDefs:function(){this.defData=Proj4js.defs[this.srsCode];var e,b;var a=this.defData.split("+");for(var f=0;f<a.length;f++){var d=a[f].split("=");e=d[0].toLowerCase();b=d[1];switch(e.replace(/\s/gi,"")){case"":break;case"title":this.title=b;break;case"proj":this.projName=b.replace(/\s/gi,"");break;case"units":this.units=b.replace(/\s/gi,"");break;case"datum":this.datumCode=b.replace(/\s/gi,"");break;case"nadgrids":this.nagrids=b.replace(/\s/gi,"");break;case"ellps":this.ellps=b.replace(/\s/gi,"");break;case"a":this.a=parseFloat(b);break;case"b":this.b=parseFloat(b);break;case"rf":this.rf=parseFloat(b);break;case"lat_0":this.lat0=b*Proj4js.common.D2R;break;case"lat_1":this.lat1=b*Proj4js.common.D2R;break;case"lat_2":this.lat2=b*Proj4js.common.D2R;break;case"lat_ts":this.lat_ts=b*Proj4js.common.D2R;break;case"lon_0":this.long0=b*Proj4js.common.D2R;break;case"alpha":this.alpha=parseFloat(b)*Proj4js.common.D2R;break;case"lonc":this.longc=b*Proj4js.common.D2R;break;case"x_0":this.x0=parseFloat(b);break;case"y_0":this.y0=parseFloat(b);break;case"k_0":this.k0=parseFloat(b);break;case"k":this.k0=parseFloat(b);break;case"R_A":this.R=true;break;case"zone":this.zone=parseInt(b);break;case"south":this.utmSouth=true;break;case"towgs84":this.datum_params=b.split(",");break;case"to_meter":this.to_meter=parseFloat(b);break;case"from_greenwich":this.from_greenwich=b*Proj4js.common.D2R;break;case"pm":b=b.replace(/\s/gi,"");this.from_greenwich=Proj4js.PrimeMeridian[b]?Proj4js.PrimeMeridian[b]:parseFloat(b);this.from_greenwich*=Proj4js.common.D2R;break;case"no_defs":break;default:}}this.deriveConstants()},deriveConstants:function(){if(this.nagrids=="@null"){this.datumCode="none"}if(this.datumCode&&this.datumCode!="none"){var a=Proj4js.Datum[this.datumCode];if(a){this.datum_params=a.towgs84.split(",");this.ellps=a.ellipse;this.datumName=a.datumName?a.datumName:this.datumCode}}if(!this.a){var b=Proj4js.Ellipsoid[this.ellps]?Proj4js.Ellipsoid[this.ellps]:Proj4js.Ellipsoid.WGS84;Proj4js.extend(this,b)}if(this.rf&&!this.b){this.b=(1-1/this.rf)*this.a}if(Math.abs(this.a-this.b)<Proj4js.common.EPSLN){this.sphere=true;this.b=this.a}this.a2=this.a*this.a;this.b2=this.b*this.b;this.es=(this.a2-this.b2)/this.a2;this.e=Math.sqrt(this.es);if(this.R_A){this.a*=1-this.es*(Proj4js.common.SIXTH+this.es*(Proj4js.RA4+this.es*Proj4js.RA6));this.a2=this.a*this.a;this.b2=this.b*this.b;this.es=0}this.ep2=(this.a2-this.b2)/this.b2;if(!this.k0){this.k0=1}this.datum=new Proj4js.datum(this)}});Proj4js.Proj.longlat={init:function(){},forward:function(a){return a},inverse:function(a){return a}};Proj4js.defs={WGS84:"+title=long/lat:WGS84 +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees","EPSG:4326":"+title=long/lat:WGS84 +proj=longlat +a=6378137.0 +b=6356752.31424518 +ellps=WGS84 +datum=WGS84 +units=degrees","EPSG:4269":"+title=long/lat:NAD83 +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"};Proj4js.common={PI:3.141592653589793,HALF_PI:1.5707963267948966,TWO_PI:6.283185307179586,FORTPI:0.7853981633974483,R2D:57.29577951308232,D2R:0.017453292519943295,SEC_TO_RAD:0.00000484813681109536,EPSLN:1e-10,MAX_ITER:20,COS_67P5:0.3826834323650898,AD_C:1.0026,PJD_UNKNOWN:0,PJD_3PARAM:1,PJD_7PARAM:2,PJD_GRIDSHIFT:3,PJD_WGS84:4,PJD_NODATUM:5,SRS_WGS84_SEMIMAJOR:6378137,SIXTH:0.16666666666666666,RA4:0.04722222222222222,RA6:0.022156084656084655,RV4:0.06944444444444445,RV6:0.04243827160493827,msfnz:function(d,b,e){var a=d*b;return e/(Math.sqrt(1-a*a))},tsfnz:function(f,e,d){var a=f*d;var b=0.5*f;a=Math.pow(((1-a)/(1+a)),b);return(Math.tan(0.5*(this.HALF_PI-e))/a)},phi2z:function(g,f){var e=0.5*g;var a,b;var d=this.HALF_PI-2*Math.atan(f);for(i=0;i<=15;i++){a=g*Math.sin(d);b=this.HALF_PI-2*Math.atan(f*(Math.pow(((1-a)/(1+a)),e)))-d;d+=b;if(Math.abs(b)<=1e-10){return d}}alert("phi2z has NoConvergence");return(-9999)},qsfnz:function(d,b,e){var a;if(d>1e-7){a=d*b;return((1-d*d)*(b/(1-a*a)-(0.5/d)*Math.log((1-a)/(1+a))))}else{return(2*b)}},asinz:function(a){if(Math.abs(a)>1){a=(a>1)?1:-1}return Math.asin(a)},e0fn:function(a){return(1-0.25*a*(1+a/16*(3+1.25*a)))},e1fn:function(a){return(0.375*a*(1+0.25*a*(1+0.46875*a)))},e2fn:function(a){return(0.05859375*a*a*(1+0.75*a))},e3fn:function(a){return(a*a*a*(35/3072))},mlfn:function(f,e,d,b,a){return(f*a-e*Math.sin(2*a)+d*Math.sin(4*a)-b*Math.sin(6*a))},srat:function(a,b){return(Math.pow((1-a)/(1+a),b))},sign:function(a){if(a<0){return(-1)}else{return(1)}},adjust_lon:function(a){a=(Math.abs(a)<this.PI)?a:(a-(this.sign(a)*this.TWO_PI));return a},adjust_lat:function(a){a=(Math.abs(a)<this.HALF_PI)?a:(a-(this.sign(a)*this.PI));return a},latiso:function(e,d,b){if(Math.abs(d)>this.HALF_PI){return +Number.NaN}if(d==this.HALF_PI){return Number.POSITIVE_INFINITY}if(d==-1*this.HALF_PI){return -1*Number.POSITIVE_INFINITY}var a=e*b;return Math.log(Math.tan((this.HALF_PI+d)/2))+e*Math.log((1-a)/(1+a))/2},fL:function(b,a){return 2*Math.atan(b*Math.exp(a))-this.HALF_PI},invlatiso:function(f,d){var b=this.fL(1,d);var e=0;var a=0;do{e=b;a=f*Math.sin(e);b=this.fL(Math.exp(f*Math.log((1+a)/(1-a))/2),d)}while(Math.abs(b-e)>1e-12);return b},sinh:function(a){var b=Math.exp(a);b=(b-1/b)/2;return b},cosh:function(a){var b=Math.exp(a);b=(b+1/b)/2;return b},tanh:function(a){var b=Math.exp(a);b=(b-1/b)/(b+1/b);return b},asinh:function(a){var b=(a>=0?1:-1);return b*(Math.log(Math.abs(a)+Math.sqrt(a*a+1)))},acosh:function(a){return 2*Math.log(Math.sqrt((a+1)/2)+Math.sqrt((a-1)/2))},atanh:function(a){return Math.log((a-1)/(a+1))/2},gN:function(b,g,f){var d=g*f;return b/Math.sqrt(1-d*d)}};Proj4js.datum=Proj4js.Class({initialize:function(b){this.datum_type=Proj4js.common.PJD_WGS84;if(b.datumCode&&b.datumCode=="none"){this.datum_type=Proj4js.common.PJD_NODATUM}if(b&&b.datum_params){for(var a=0;a<b.datum_params.length;a++){b.datum_params[a]=parseFloat(b.datum_params[a])}if(b.datum_params[0]!=0||b.datum_params[1]!=0||b.datum_params[2]!=0){this.datum_type=Proj4js.common.PJD_3PARAM}if(b.datum_params.length>3){if(b.datum_params[3]!=0||b.datum_params[4]!=0||b.datum_params[5]!=0||b.datum_params[6]!=0){this.datum_type=Proj4js.common.PJD_7PARAM;b.datum_params[3]*=Proj4js.common.SEC_TO_RAD;b.datum_params[4]*=Proj4js.common.SEC_TO_RAD;b.datum_params[5]*=Proj4js.common.SEC_TO_RAD;b.datum_params[6]=(b.datum_params[6]/1000000)+1}}}if(b){this.a=b.a;this.b=b.b;this.es=b.es;this.ep2=b.ep2;this.datum_params=b.datum_params}},compare_datums:function(a){if(this.datum_type!=a.datum_type){return false}else{if(this.a!=a.a||Math.abs(this.es-a.es)>5e-11){return false}else{if(this.datum_type==Proj4js.common.PJD_3PARAM){return(this.datum_params[0]==a.datum_params[0]&&this.datum_params[1]==a.datum_params[1]&&this.datum_params[2]==a.datum_params[2])}else{if(this.datum_type==Proj4js.common.PJD_7PARAM){return(this.datum_params[0]==a.datum_params[0]&&this.datum_params[1]==a.datum_params[1]&&this.datum_params[2]==a.datum_params[2]&&this.datum_params[3]==a.datum_params[3]&&this.datum_params[4]==a.datum_params[4]&&this.datum_params[5]==a.datum_params[5]&&this.datum_params[6]==a.datum_params[6])}else{if(this.datum_type==Proj4js.common.PJD_GRIDSHIFT){return strcmp(pj_param(this.params,"snadgrids").s,pj_param(a.params,"snadgrids").s)==0}else{return true}}}}}},geodetic_to_geocentric:function(d){var q=d.x;var j=d.y;var e=d.z?d.z:0;var f;var b;var a;var m=0;var o;var l;var h;var g;if(j<-Proj4js.common.HALF_PI&&j>-1.001*Proj4js.common.HALF_PI){j=-Proj4js.common.HALF_PI}else{if(j>Proj4js.common.HALF_PI&&j<1.001*Proj4js.common.HALF_PI){j=Proj4js.common.HALF_PI}else{if((j<-Proj4js.common.HALF_PI)||(j>Proj4js.common.HALF_PI)){Proj4js.reportError("geocent:lat out of range:"+j);return null}}}if(q>Proj4js.common.PI){q-=(2*Proj4js.common.PI)}l=Math.sin(j);g=Math.cos(j);h=l*l;o=this.a/(Math.sqrt(1-this.es*h));f=(o+e)*g*Math.cos(q);b=(o+e)*g*Math.sin(q);a=((o*(1-this.es))+e)*l;d.x=f;d.y=b;d.z=a;return m},geocentric_to_geodetic:function(z){var F=1e-12;var B=(F*F);var g=30;var q;var j;var a;var s;var b;var r;var o;var E;var D;var m;var v;var u;var f;var C;var h=z.x;var e=z.y;var d=z.z?z.z:0;var l;var w;var t;f=false;q=Math.sqrt(h*h+e*e);j=Math.sqrt(h*h+e*e+d*d);if(q/this.a<F){f=true;l=0;if(j/this.a<F){w=Proj4js.common.HALF_PI;t=-this.b;return}}else{l=Math.atan2(e,h)}a=d/j;s=q/j;b=1/Math.sqrt(1-this.es*(2-this.es)*s*s);E=s*(1-this.es)*b;D=a*b;C=0;do{C++;o=this.a/Math.sqrt(1-this.es*D*D);t=q*E+d*D-o*(1-this.es*D*D);r=this.es*o/(o+t);b=1/Math.sqrt(1-r*(2-r)*s*s);m=s*(1-r)*b;v=a*b;u=v*E-m*D;E=m;D=v}while(u*u>B&&C<g);w=Math.atan(v/Math.abs(m));z.x=l;z.y=w;z.z=t;return z},geocentric_to_geodetic_noniter:function(w){var e=w.x;var d=w.y;var a=w.z?w.z:0;var h;var v;var q;var f;var s;var u;var r;var m;var j;var l;var C;var g;var B;var z;var t;var o;var b;e=parseFloat(e);d=parseFloat(d);a=parseFloat(a);b=false;if(e!=0){h=Math.atan2(d,e)}else{if(d>0){h=Proj4js.common.HALF_PI}else{if(d<0){h=-Proj4js.common.HALF_PI}else{b=true;h=0;if(a>0){v=Proj4js.common.HALF_PI}else{if(a<0){v=-Proj4js.common.HALF_PI}else{v=Proj4js.common.HALF_PI;q=-this.b;return}}}}}s=e*e+d*d;f=Math.sqrt(s);u=a*Proj4js.common.AD_C;m=Math.sqrt(u*u+s);l=u/m;g=f/m;C=l*l*l;r=a+this.b*this.ep2*C;o=f-this.a*this.es*g*g*g;j=Math.sqrt(r*r+o*o);B=r/j;z=o/j;t=this.a/Math.sqrt(1-this.es*B*B);if(z>=Proj4js.common.COS_67P5){q=f/z-t}else{if(z<=-Proj4js.common.COS_67P5){q=f/-z-t}else{q=a/B+t*(this.es-1)}}if(b==false){v=Math.atan(B/z)}w.x=h;w.y=v;w.z=q;return w},geocentric_to_wgs84:function(b){if(this.datum_type==Proj4js.common.PJD_3PARAM){b.x+=this.datum_params[0];b.y+=this.datum_params[1];b.z+=this.datum_params[2]}else{if(this.datum_type==Proj4js.common.PJD_7PARAM){var g=this.datum_params[0];var e=this.datum_params[1];var l=this.datum_params[2];var f=this.datum_params[3];var m=this.datum_params[4];var j=this.datum_params[5];var h=this.datum_params[6];var d=h*(b.x-j*b.y+m*b.z)+g;var a=h*(j*b.x+b.y-f*b.z)+e;var o=h*(-m*b.x+f*b.y+b.z)+l;b.x=d;b.y=a;b.z=o}}},geocentric_from_wgs84:function(d){if(this.datum_type==Proj4js.common.PJD_3PARAM){d.x-=this.datum_params[0];d.y-=this.datum_params[1];d.z-=this.datum_params[2]}else{if(this.datum_type==Proj4js.common.PJD_7PARAM){var h=this.datum_params[0];var e=this.datum_params[1];var m=this.datum_params[2];var g=this.datum_params[3];var o=this.datum_params[4];var l=this.datum_params[5];var j=this.datum_params[6];var f=(d.x-h)/j;var b=(d.y-e)/j;var a=(d.z-m)/j;d.x=f+l*b-o*a;d.y=-l*f+b+g*a;d.z=o*f-g*b+a}}}});Proj4js.Point=Proj4js.Class({initialize:function(a,e,d){if(typeof a=="object"){this.x=a[0];this.y=a[1];this.z=a[2]||0}else{if(typeof a=="string"){var b=a.split(",");this.x=parseFloat(b[0]);this.y=parseFloat(b[1]);this.z=parseFloat(b[2])||0}else{this.x=a;this.y=e;this.z=d||0}}},clone:function(){return new Proj4js.Point(this.x,this.y,this.z)},toString:function(){return("x="+this.x+",y="+this.y)},toShortString:function(){return(this.x+", "+this.y)}});Proj4js.PrimeMeridian={greenwich:0,lisbon:-9.131906111111,paris:2.337229166667,bogota:-74.080916666667,madrid:-3.687938888889,rome:12.452333333333,bern:7.439583333333,jakarta:106.807719444444,ferro:-17.666666666667,brussels:4.367975,stockholm:18.058277777778,athens:23.7163375,oslo:10.722916666667};Proj4js.Ellipsoid={MERIT:{a:6378137,rf:298.257,ellipseName:"MERIT 1983"},SGS85:{a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},GRS80:{a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},IAU76:{a:6378140,rf:298.257,ellipseName:"IAU 1976"},airy:{a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},"APL4.":{a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},NWL9D:{a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},mod_airy:{a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},andrae:{a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},aust_SA:{a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},GRS67:{a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},bessel:{a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},bess_nam:{a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},clrk66:{a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},clrk80:{a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},CPM:{a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},delmbr:{a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},engelis:{a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},evrst30:{a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},evrst48:{a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},evrst56:{a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},evrst69:{a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},evrstSS:{a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},fschr60:{a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},fschr60m:{a:6378155,rf:298.3,ellipseName:"Fischer 1960"},fschr68:{a:6378150,rf:298.3,ellipseName:"Fischer 1968"},helmert:{a:6378200,rf:298.3,ellipseName:"Helmert 1906"},hough:{a:6378270,rf:297,ellipseName:"Hough"},intl:{a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},kaula:{a:6378163,rf:298.24,ellipseName:"Kaula 1961"},lerch:{a:6378139,rf:298.257,ellipseName:"Lerch 1979"},mprts:{a:6397300,rf:191,ellipseName:"Maupertius 1738"},new_intl:{a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},plessis:{a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},krass:{a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},SEasia:{a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},walbeck:{a:6376896,b:6355834.8467,ellipseName:"Walbeck"},WGS60:{a:6378165,rf:298.3,ellipseName:"WGS 60"},WGS66:{a:6378145,rf:298.25,ellipseName:"WGS 66"},WGS72:{a:6378135,rf:298.26,ellipseName:"WGS 72"},WGS84:{a:6378137,rf:298.257223563,ellipseName:"WGS 84"},sphere:{a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}};Proj4js.Datum={WGS84:{towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},GGRS87:{towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},NAD83:{towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},NAD27:{nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},potsdam:{towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},carthage:{towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},hermannskogel:{towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},ire65:{towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},nzgd49:{towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},OSGB36:{towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"}};Proj4js.WGS84=new Proj4js.Proj("WGS84");Proj4js.Datum.OSB36=Proj4js.Datum.OSGB36;Proj4js.Proj.aea={init:function(){if(Math.abs(this.lat1+this.lat2)<Proj4js.common.EPSLN){Proj4js.reportError("aeaInitEqualLatitudes");return}this.temp=this.b/this.a;this.es=1-Math.pow(this.temp,2);this.e3=Math.sqrt(this.es);this.sin_po=Math.sin(this.lat1);this.cos_po=Math.cos(this.lat1);this.t1=this.sin_po;this.con=this.sin_po;this.ms1=Proj4js.common.msfnz(this.e3,this.sin_po,this.cos_po);this.qs1=Proj4js.common.qsfnz(this.e3,this.sin_po,this.cos_po);this.sin_po=Math.sin(this.lat2);this.cos_po=Math.cos(this.lat2);this.t2=this.sin_po;this.ms2=Proj4js.common.msfnz(this.e3,this.sin_po,this.cos_po);this.qs2=Proj4js.common.qsfnz(this.e3,this.sin_po,this.cos_po);this.sin_po=Math.sin(this.lat0);this.cos_po=Math.cos(this.lat0);this.t3=this.sin_po;this.qs0=Proj4js.common.qsfnz(this.e3,this.sin_po,this.cos_po);if(Math.abs(this.lat1-this.lat2)>Proj4js.common.EPSLN){this.ns0=(this.ms1*this.ms1-this.ms2*this.ms2)/(this.qs2-this.qs1)}else{this.ns0=this.con}this.c=this.ms1*this.ms1+this.ns0*this.qs1;this.rh=this.a*Math.sqrt(this.c-this.ns0*this.qs0)/this.ns0},forward:function(f){var g=f.x;var e=f.y;this.sin_phi=Math.sin(e);this.cos_phi=Math.cos(e);var b=Proj4js.common.qsfnz(this.e3,this.sin_phi,this.cos_phi);var j=this.a*Math.sqrt(this.c-this.ns0*b)/this.ns0;var d=this.ns0*Proj4js.common.adjust_lon(g-this.long0);var a=j*Math.sin(d)+this.x0;var h=this.rh-j*Math.cos(d)+this.y0;f.x=a;f.y=h;return f},inverse:function(f){var h,a,b,d,g,e;f.x-=this.x0;f.y=this.rh-f.y+this.y0;if(this.ns0>=0){h=Math.sqrt(f.x*f.x+f.y*f.y);b=1}else{h=-Math.sqrt(f.x*f.x+f.y*f.y);b=-1}d=0;if(h!=0){d=Math.atan2(b*f.x,b*f.y)}b=h*this.ns0/this.a;a=(this.c-b*b)/this.ns0;if(this.e3>=1e-10){b=1-0.5*(1-this.es)*Math.log((1-this.e3)/(1+this.e3))/this.e3;if(Math.abs(Math.abs(b)-Math.abs(a))>1e-10){e=this.phi1z(this.e3,a)}else{if(a>=0){e=0.5*PI}else{e=-0.5*PI}}}else{e=this.phi1z(e3,a)}g=Proj4js.common.adjust_lon(d/this.ns0+this.long0);f.x=g;f.y=e;return f},phi1z:function(j,a){var b,d,e;var h=Proj4js.common.asinz(0.5*a);if(j<Proj4js.common.EPSLN){return h}var g=j*j;for(var f=1;f<=25;f++){sinphi=Math.sin(h);cosphi=Math.cos(h);b=j*sinphi;d=1-b*b;e=0.5*d*d/cosphi*(a/(1-g)-sinphi/d+0.5/j*Math.log((1-b)/(1+b)));h=h+e;if(Math.abs(e)<=1e-7){return h}}Proj4js.reportError("aea:phi1z:Convergence error");return null}};Proj4js.Proj.sterea={dependsOn:"gauss",init:function(){Proj4js.Proj.gauss.init.apply(this);if(!this.rc){Proj4js.reportError("sterea:init:E_ERROR_0");return}this.sinc0=Math.sin(this.phic0);this.cosc0=Math.cos(this.phic0);this.R2=2*this.rc;if(!this.title){this.title="Oblique Stereographic Alternative"}},forward:function(a){a.x=Proj4js.common.adjust_lon(a.x-this.long0);Proj4js.Proj.gauss.forward.apply(this,[a]);sinc=Math.sin(a.y);cosc=Math.cos(a.y);cosl=Math.cos(a.x);k=this.k0*this.R2/(1+this.sinc0*sinc+this.cosc0*cosc*cosl);a.x=k*cosc*Math.sin(a.x);a.y=k*(this.cosc0*sinc-this.sinc0*cosc*cosl);a.x=this.a*a.x+this.x0;a.y=this.a*a.y+this.y0;return a},inverse:function(b){var d,a;b.x=(b.x-this.x0)/this.a;b.y=(b.y-this.y0)/this.a;b.x/=this.k0;b.y/=this.k0;if((rho=Math.sqrt(b.x*b.x+b.y*b.y))){c=2*Math.atan2(rho,this.R2);sinc=Math.sin(c);cosc=Math.cos(c);a=Math.asin(cosc*this.sinc0+b.y*sinc*this.cosc0/rho);d=Math.atan2(b.x*sinc,rho*this.cosc0*cosc-b.y*this.sinc0*sinc)}else{a=this.phic0;d=0}b.x=d;b.y=a;Proj4js.Proj.gauss.inverse.apply(this,[b]);b.x=Proj4js.common.adjust_lon(b.x+this.long0);return b}};function phi4z(e,l,j,h,g,B,z,w,f){var m,v,t,u,r,q,p,o,d,s;f=B;for(s=1;s<=15;s++){m=Math.sin(f);tanphi=Math.tan(f);w=tanphi*Math.sqrt(1-e*m*m);v=Math.sin(2*f);u=l*f-j*v+h*Math.sin(4*f)-g*Math.sin(6*f);r=l-2*j*Math.cos(2*f)+4*h*Math.cos(4*f)-6*g*Math.cos(6*f);q=2*u+w*(u*u+z)-2*B*(w*u+1);p=e*v*(u*u+z-2*B*u)/(2*w);o=2*(B-u)*(w*r-2/v)-2*r;d=q/(p+o);f+=d;if(Math.abs(d)<=1e-10){return(f)}}Proj4js.reportError("phi4z: No convergence");return null}function e4fn(a){var b,d;b=1+a;d=1-a;return(Math.sqrt((Math.pow(b,b))*(Math.pow(d,d))))}Proj4js.Proj.poly={init:function(){var a;if(this.lat0=0){this.lat0=90}this.temp=this.b/this.a;this.es=1-Math.pow(this.temp,2);this.e=Math.sqrt(this.es);this.e0=Proj4js.common.e0fn(this.es);this.e1=Proj4js.common.e1fn(this.es);this.e2=Proj4js.common.e2fn(this.es);this.e3=Proj4js.common.e3fn(this.es);this.ml0=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,this.lat0)},forward:function(e){var a,g;var j;var m;var f,h;var d;var q,o;var b=e.x;var l=e.y;f=Proj4js.common.adjust_lon(b-this.long0);if(Math.abs(l)<=1e-7){q=this.x0+this.a*f;o=this.y0-this.a*this.ml0}else{a=Math.sin(l);g=Math.cos(l);h=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,l);d=Proj4js.common.msfnz(this.e,a,g);f=a;q=this.x0+this.a*d*Math.sin(f)/a;o=this.y0+this.a*(h-this.ml0+d*(1-Math.cos(f))/a)}e.x=q;e.y=o;return e},inverse:function(d){var o,h;var g;var q;var l;var e,f;var m;var a,j;d.x-=this.x0;d.y-=this.y0;g=this.ml0+d.y/this.a;m=0;if(Math.abs(g)<=1e-7){a=d.x/this.a+this.long0;j=0}else{q=g*g+(d.x/this.a)*(d.x/this.a);m=phi4z(this.es,this.e0,this.e1,this.e2,this.e3,this.al,q,l,j);if(m!=1){return(m)}a=Proj4js.common.adjust_lon((asinz(d.x*l/this.a)/Math.sin(j))+this.long0)}d.x=a;d.y=j;return d}};Proj4js.Proj.equi={init:function(){if(!this.x0){this.x0=0}if(!this.y0){this.y0=0}if(!this.lat0){this.lat0=0}if(!this.long0){this.long0=0}},forward:function(e){var f=e.x;var d=e.y;var b=Proj4js.common.adjust_lon(f-this.long0);var a=this.x0+this.a*b*Math.cos(this.lat0);var g=this.y0+this.a*d;this.t1=a;this.t2=Math.cos(this.lat0);e.x=a;e.y=g;return e},inverse:function(b){b.x-=this.x0;b.y-=this.y0;var a=b.y/this.a;if(Math.abs(a)>Proj4js.common.HALF_PI){Proj4js.reportError("equi:Inv:DataError")}var d=Proj4js.common.adjust_lon(this.long0+b.x/(this.a*Math.cos(this.lat0)));b.x=d;b.y=a}};Proj4js.Proj.merc={init:function(){if(this.lat_ts){if(this.sphere){this.k0=Math.cos(this.lat_ts)}else{this.k0=Proj4js.common.msfnz(this.es,Math.sin(this.lat_ts),Math.cos(this.lat_ts))}}},forward:function(f){var g=f.x;var e=f.y;if(e*Proj4js.common.R2D>90&&e*Proj4js.common.R2D<-90&&g*Proj4js.common.R2D>180&&g*Proj4js.common.R2D<-180){Proj4js.reportError("merc:forward: llInputOutOfRange: "+g+" : "+e);return null}var a,h;if(Math.abs(Math.abs(e)-Proj4js.common.HALF_PI)<=Proj4js.common.EPSLN){Proj4js.reportError("merc:forward: ll2mAtPoles");return null}else{if(this.sphere){a=this.x0+this.a*this.k0*Proj4js.common.adjust_lon(g-this.long0);h=this.y0+this.a*this.k0*Math.log(Math.tan(Proj4js.common.FORTPI+0.5*e))}else{var d=Math.sin(e);var b=Proj4js.common.tsfnz(this.e,e,d);a=this.x0+this.a*this.k0*Proj4js.common.adjust_lon(g-this.long0);h=this.y0-this.a*this.k0*Math.log(b)}f.x=a;f.y=h;return f}},inverse:function(e){var a=e.x-this.x0;var g=e.y-this.y0;var f,d;if(this.sphere){d=Proj4js.common.HALF_PI-2*Math.atan(Math.exp(-g/this.a*this.k0))}else{var b=Math.exp(-g/(this.a*this.k0));d=Proj4js.common.phi2z(this.e,b);if(d==-9999){Proj4js.reportError("merc:inverse: lat = -9999");return null}}f=Proj4js.common.adjust_lon(this.long0+a/(this.a*this.k0));e.x=f;e.y=d;return e}};Proj4js.Proj.utm={dependsOn:"tmerc",init:function(){if(!this.zone){Proj4js.reportError("utm:init: zone must be specified for UTM");return}this.lat0=0;this.long0=((6*Math.abs(this.zone))-183)*Proj4js.common.D2R;this.x0=500000;this.y0=this.utmSouth?10000000:0;this.k0=0.9996;Proj4js.Proj.tmerc.init.apply(this);this.forward=Proj4js.Proj.tmerc.forward;this.inverse=Proj4js.Proj.tmerc.inverse}};Proj4js.Proj.eqdc={init:function(){if(!this.mode){this.mode=0}this.temp=this.b/this.a;this.es=1-Math.pow(this.temp,2);this.e=Math.sqrt(this.es);this.e0=Proj4js.common.e0fn(this.es);this.e1=Proj4js.common.e1fn(this.es);this.e2=Proj4js.common.e2fn(this.es);this.e3=Proj4js.common.e3fn(this.es);this.sinphi=Math.sin(this.lat1);this.cosphi=Math.cos(this.lat1);this.ms1=Proj4js.common.msfnz(this.e,this.sinphi,this.cosphi);this.ml1=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,this.lat1);if(this.mode!=0){if(Math.abs(this.lat1+this.lat2)<Proj4js.common.EPSLN){Proj4js.reportError("eqdc:Init:EqualLatitudes")}this.sinphi=Math.sin(this.lat2);this.cosphi=Math.cos(this.lat2);this.ms2=Proj4js.common.msfnz(this.e,this.sinphi,this.cosphi);this.ml2=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,this.lat2);if(Math.abs(this.lat1-this.lat2)>=Proj4js.common.EPSLN){this.ns=(this.ms1-this.ms2)/(this.ml2-this.ml1)}else{this.ns=this.sinphi}}else{this.ns=this.sinphi}this.g=this.ml1+this.ms1/this.ns;this.ml0=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,this.lat0);this.rh=this.a*(this.g-this.ml0)},forward:function(e){var f=e.x;var d=e.y;var j=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,d);var h=this.a*(this.g-j);var b=this.ns*Proj4js.common.adjust_lon(f-this.long0);var a=this.x0+h*Math.sin(b);var g=this.y0+this.rh-h*Math.cos(b);e.x=a;e.y=g;return e},inverse:function(e){e.x-=this.x0;e.y=this.rh-e.y+this.y0;var a,h;if(this.ns>=0){var h=Math.sqrt(e.x*e.x+e.y*e.y);var a=1}else{h=-Math.sqrt(e.x*e.x+e.y*e.y);a=-1}var b=0;if(h!=0){b=Math.atan2(a*e.x,a*e.y)}var g=this.g-h/this.a;var d=this.phi3z(this.ml,this.e0,this.e1,this.e2,this.e3);var f=Proj4js.common.adjust_lon(this.long0+b/this.ns);e.x=f;e.y=d;return e},phi3z:function(j,h,g,f,e){var d;var a;d=j;for(var b=0;b<15;b++){a=(j+g*Math.sin(2*d)-f*Math.sin(4*d)+e*Math.sin(6*d))/h-d;d+=a;if(Math.abs(a)<=1e-10){return d}}Proj4js.reportError("PHI3Z-CONV:Latitude failed to converge after 15 iterations");return null}};Proj4js.Proj.tmerc={init:function(){this.e0=Proj4js.common.e0fn(this.es);this.e1=Proj4js.common.e1fn(this.es);this.e2=Proj4js.common.e2fn(this.es);this.e3=Proj4js.common.e3fn(this.es);this.ml0=this.a*Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,this.lat0)},forward:function(d){var a=d.x;var q=d.y;var g=Proj4js.common.adjust_lon(a-this.long0);var e;var w,u;var v=Math.sin(q);var m=Math.cos(q);if(this.sphere){var s=m*Math.sin(g);if((Math.abs(Math.abs(s)-1))<1e-10){Proj4js.reportError("tmerc:forward: Point projects into infinity");return(93)}else{w=0.5*this.a*this.k0*Math.log((1+s)/(1-s));e=Math.acos(m*Math.cos(g)/Math.sqrt(1-s*s));if(q<0){e=-e}u=this.a*this.k0*(e-this.lat0)}}else{var l=m*g;var j=Math.pow(l,2);var o=this.ep2*Math.pow(m,2);var r=Math.tan(q);var z=Math.pow(r,2);e=1-this.es*Math.pow(v,2);var f=this.a/Math.sqrt(e);var h=this.a*Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,q);w=this.k0*f*l*(1+j/6*(1-z+o+j/20*(5-18*z+Math.pow(z,2)+72*o-58*this.ep2)))+this.x0;u=this.k0*(h-this.ml0+f*r*(j*(0.5+j/24*(5-z+9*o+4*Math.pow(o,2)+j/30*(61-58*z+Math.pow(z,2)+600*o-330*this.ep2)))))+this.y0}d.x=w;d.y=u;return d},inverse:function(C){var l,e;var L;var E;var q=6;var o,j;if(this.sphere){var H=Math.exp(C.x/(this.a*this.k0));var G=0.5*(H-1/H);var J=this.lat0+C.y/(this.a*this.k0);var F=Math.cos(J);l=Math.sqrt((1-F*F)/(1+G*G));o=Math.asinz(l);if(J<0){o=-o}if((G==0)&&(F==0)){j=this.long0}else{j=Proj4js.common.adjust_lon(Math.atan2(G,F)+this.long0)}}else{var u=C.x-this.x0;var s=C.y-this.y0;l=(this.ml0+s/this.k0)/this.a;e=l;for(E=0;;E++){L=((l+this.e1*Math.sin(2*e)-this.e2*Math.sin(4*e)+this.e3*Math.sin(6*e))/this.e0)-e;e+=L;if(Math.abs(L)<=Proj4js.common.EPSLN){break}if(E>=q){Proj4js.reportError("tmerc:inverse: Latitude failed to converge");return(95)}}if(Math.abs(e)<Proj4js.common.HALF_PI){var b=Math.sin(e);var M=Math.cos(e);var v=Math.tan(e);var K=this.ep2*Math.pow(M,2);var m=Math.pow(K,2);var w=Math.pow(v,2);var a=Math.pow(w,2);l=1-this.es*Math.pow(b,2);var D=this.a/Math.sqrt(l);var z=D*(1-this.es)/l;var I=u/(D*this.k0);var B=Math.pow(I,2);o=e-(D*v*B/z)*(0.5-B/24*(5+3*w+10*K-4*m-9*this.ep2-B/30*(61+90*w+298*K+45*a-252*this.ep2-3*m)));j=Proj4js.common.adjust_lon(this.long0+(I*(1-B/6*(1+2*w+K-B/20*(5-2*K+28*w-3*m+8*this.ep2+24*a)))/M))}else{o=Proj4js.common.HALF_PI*Proj4js.common.sign(s);j=this.long0}}C.x=j;C.y=o;return C}};Proj4js.defs.GOOGLE="+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs";Proj4js.defs["EPSG:900913"]=Proj4js.defs.GOOGLE;Proj4js.Proj.gstmerc={init:function(){var a=this.b/this.a;this.e=Math.sqrt(1-a*a);this.lc=this.long0;this.rs=Math.sqrt(1+this.e*this.e*Math.pow(Math.cos(this.lat0),4)/(1-this.e*this.e));var d=Math.sin(this.lat0);var b=Math.asin(d/this.rs);var e=Math.sin(b);this.cp=Proj4js.common.latiso(0,b,e)-this.rs*Proj4js.common.latiso(this.e,this.lat0,d);this.n2=this.k0*this.a*Math.sqrt(1-this.e*this.e)/(1-this.e*this.e*d*d);this.xs=this.x0;this.ys=this.y0-this.n2*b;if(!this.title){this.title="Gauss Schreiber transverse mercator"}},forward:function(f){var h=f.x;var e=f.y;var a=this.rs*(h-this.lc);var b=this.cp+(this.rs*Proj4js.common.latiso(this.e,e,Math.sin(e)));var g=Math.asin(Math.sin(a)/Proj4js.common.cosh(b));var d=Proj4js.common.latiso(0,g,Math.sin(g));f.x=this.xs+(this.n2*d);f.y=this.ys+(this.n2*Math.atan(Proj4js.common.sinh(b)/Math.cos(a)));return f},inverse:function(e){var b=e.x;var g=e.y;var a=Math.atan(Proj4js.common.sinh((b-this.xs)/this.n2)/Math.cos((g-this.ys)/this.n2));var f=Math.asin(Math.sin((g-this.ys)/this.n2)/Proj4js.common.cosh((b-this.xs)/this.n2));var d=Proj4js.common.latiso(0,f,Math.sin(f));e.x=this.lc+a/this.rs;e.y=Proj4js.common.invlatiso(this.e,(d-this.cp)/this.rs);return e}};Proj4js.Proj.ortho={init:function(a){this.sin_p14=Math.sin(this.lat0);this.cos_p14=Math.cos(this.lat0)},forward:function(d){var a,e;var q;var o;var f;var h;var b=d.x;var j=d.y;q=Proj4js.common.adjust_lon(b-this.long0);a=Math.sin(j);e=Math.cos(j);o=Math.cos(q);h=this.sin_p14*a+this.cos_p14*e*o;f=1;if((h>0)||(Math.abs(h)<=Proj4js.common.EPSLN)){var m=this.a*f*e*Math.sin(q);var l=this.y0+this.a*f*(this.cos_p14*a-this.sin_p14*e*o)}else{Proj4js.reportError("orthoFwdPointError")}d.x=m;d.y=l;return d},inverse:function(b){var h;var g;var e,l;var j;var d;var a,f;b.x-=this.x0;b.y-=this.y0;h=Math.sqrt(b.x*b.x+b.y*b.y);if(h>this.a+1e-7){Proj4js.reportError("orthoInvDataError")}g=Proj4js.common.asinz(h/this.a);e=Math.sin(g);cosi=Math.cos(g);a=this.long0;if(Math.abs(h)<=Proj4js.common.EPSLN){f=this.lat0}f=Proj4js.common.asinz(l*this.sin_p14+(y*e*this.cos_p14)/h);d=Math.abs(lat0)-Proj4js.common.HALF_PI;if(Math.abs(d)<=Proj4js.common.EPSLN){if(this.lat0>=0){a=Proj4js.common.adjust_lon(this.long0+Math.atan2(b.x,-b.y))}else{a=Proj4js.common.adjust_lon(this.long0-Math.atan2(-b.x,b.y))}}d=l-this.sin_p14*Math.sin(f);if((Math.abs(d)>=Proj4js.common.EPSLN)||(Math.abs(x)>=Proj4js.common.EPSLN)){a=Proj4js.common.adjust_lon(this.long0+Math.atan2((b.x*e*this.cos_p14),(d*h)))}b.x=a;b.y=f;return b}};Proj4js.Proj.somerc={init:function(){var b=this.lat0;this.lambda0=this.long0;var a=Math.sin(b);var f=this.a;var d=this.rf;var g=1/d;var j=2*g-Math.pow(g,2);var h=this.e=Math.sqrt(j);this.R=f*Math.sqrt(1-j)/(1-j*Math.pow(a,2));this.alpha=Math.sqrt(1+j/(1-j)*Math.pow(Math.cos(b),4));this.b0=Math.asin(a/this.alpha);this.K=Math.log(Math.tan(Math.PI/4+this.b0/2))-this.alpha*Math.log(Math.tan(Math.PI/4+b/2))+this.alpha*h/2*Math.log((1+h*a)/(1-h*a))},forward:function(g){var l=Math.log(Math.tan(Math.PI/4-g.y/2));var h=this.e/2*Math.log((1+this.e*Math.sin(g.y))/(1-this.e*Math.sin(g.y)));var e=-this.alpha*(l+h)+this.K;var a=2*(Math.atan(Math.exp(e))-Math.PI/4);var d=this.alpha*(g.x-this.lambda0);var j=Math.atan(Math.sin(d)/(Math.sin(this.b0)*Math.tan(a)+Math.cos(this.b0)*Math.cos(d)));var f=Math.asin(Math.cos(this.b0)*Math.sin(a)-Math.sin(this.b0)*Math.cos(a)*Math.cos(d));g.y=this.R/2*Math.log((1+Math.sin(f))/(1-Math.sin(f)))+this.y0;g.x=this.R*j+this.x0;return g},inverse:function(e){var d=e.x-this.x0;var f=e.y-this.y0;var q=d/this.R;var g=2*(Math.atan(Math.exp(f/this.R))-Math.PI/4);var m=Math.asin(Math.cos(this.b0)*Math.sin(g)+Math.sin(this.b0)*Math.cos(g)*Math.cos(q));var o=Math.atan(Math.sin(q)/(Math.cos(this.b0)*Math.cos(q)-Math.sin(this.b0)*Math.tan(g)));var l=this.lambda0+o/this.alpha;var j=0;var r=m;var a=-1000;var h=0;while(Math.abs(r-a)>1e-7){if(++h>20){Proj4js.reportError("omercFwdInfinity");return}j=1/this.alpha*(Math.log(Math.tan(Math.PI/4+m/2))-this.K)+this.e*Math.log(Math.tan(Math.PI/4+Math.asin(this.e*Math.sin(r))/2));a=r;r=2*Math.atan(Math.exp(j))-Math.PI/2}e.x=l;e.y=r;return e}};Proj4js.Proj.stere={ssfn_:function(a,d,b){d*=b;return(Math.tan(0.5*(Proj4js.common.HALF_PI+a))*Math.pow((1-d)/(1+d),0.5*b))},TOL:1e-8,NITER:8,CONV:1e-10,S_POLE:0,N_POLE:1,OBLIQ:2,EQUIT:3,init:function(){this.phits=this.lat_ts?this.lat_ts:Proj4js.common.HALF_PI;var a=Math.abs(this.lat0);if((Math.abs(a)-Proj4js.common.HALF_PI)<Proj4js.common.EPSLN){this.mode=this.lat0<0?this.S_POLE:this.N_POLE}else{this.mode=a>Proj4js.common.EPSLN?this.OBLIQ:this.EQUIT}this.phits=Math.abs(this.phits);if(this.es){var b;switch(this.mode){case this.N_POLE:case this.S_POLE:if(Math.abs(this.phits-Proj4js.common.HALF_PI)<Proj4js.common.EPSLN){this.akm1=2*this.k0/Math.sqrt(Math.pow(1+this.e,1+this.e)*Math.pow(1-this.e,1-this.e))}else{a=Math.sin(this.phits);this.akm1=Math.cos(this.phits)/Proj4js.common.tsfnz(this.e,this.phits,a);a*=this.e;this.akm1/=Math.sqrt(1-a*a)}break;case this.EQUIT:this.akm1=2*this.k0;break;case this.OBLIQ:a=Math.sin(this.lat0);b=2*Math.atan(this.ssfn_(this.lat0,a,this.e))-Proj4js.common.HALF_PI;a*=this.e;this.akm1=2*this.k0*Math.cos(this.lat0)/Math.sqrt(1-a*a);this.sinX1=Math.sin(b);this.cosX1=Math.cos(b);break}}else{switch(this.mode){case this.OBLIQ:this.sinph0=Math.sin(this.lat0);this.cosph0=Math.cos(this.lat0);case this.EQUIT:this.akm1=2*this.k0;break;case this.S_POLE:case this.N_POLE:this.akm1=Math.abs(this.phits-Proj4js.common.HALF_PI)>=Proj4js.common.EPSLN?Math.cos(this.phits)/Math.tan(Proj4js.common.FORTPI-0.5*this.phits):2*this.k0;break}}},forward:function(d){var b=d.x;var g=d.y;var l,h;if(this.sphere){var a,e,j,f;a=Math.sin(g);e=Math.cos(g);j=Math.cos(b);f=Math.sin(b);switch(this.mode){case this.EQUIT:h=1+e*j;if(h<=Proj4js.common.EPSLN){F_ERROR}h=this.akm1/h;l=h*e*f;h*=a;break;case this.OBLIQ:h=1+this.sinph0*a+this.cosph0*e*j;if(h<=Proj4js.common.EPSLN){F_ERROR}h=this.akm1/h;l=h*e*f;h*=this.cosph0*a-this.sinph0*e*j;break;case this.N_POLE:j=-j;g=-g;case this.S_POLE:if(Math.abs(g-Proj4js.common.HALF_PI)<this.TOL){F_ERROR}h=this.akm1*Math.tan(Proj4js.common.FORTPI+0.5*g);l=f*h;h*=j;break}}else{j=Math.cos(b);f=Math.sin(b);a=Math.sin(g);if(this.mode==this.OBLIQ||this.mode==this.EQUIT){X=2*Math.atan(this.ssfn_(g,a,this.e));sinX=Math.sin(X-Proj4js.common.HALF_PI);cosX=Math.cos(X)}switch(this.mode){case this.OBLIQ:A=this.akm1/(this.cosX1*(1+this.sinX1*sinX+this.cosX1*cosX*j));h=A*(this.cosX1*sinX-this.sinX1*cosX*j);l=A*cosX;break;case this.EQUIT:A=2*this.akm1/(1+cosX*j);h=A*sinX;l=A*cosX;break;case this.S_POLE:g=-g;j=-j;a=-a;case this.N_POLE:l=this.akm1*Proj4js.common.tsfnz(this.e,g,a);h=-l*j;break}l=l*f}d.x=l*this.a+this.x0;d.y=h*this.a+this.y0;return d},inverse:function(d){var t=(d.x-this.x0)/this.a;var q=(d.y-this.y0)/this.a;var b,o;var h,a,s=0,e=0,r,g=0,l=0;var j;if(this.sphere){var m,u,f,v;u=Math.sqrt(t*t+q*q);m=2*Math.atan(u/this.akm1);f=Math.sin(m);v=Math.cos(m);b=0;switch(this.mode){case this.EQUIT:if(Math.abs(u)<=Proj4js.common.EPSLN){o=0}else{o=Math.asin(q*f/u)}if(v!=0||t!=0){b=Math.atan2(t*f,v*u)}break;case this.OBLIQ:if(Math.abs(u)<=Proj4js.common.EPSLN){o=this.phi0}else{o=Math.asin(v*sinph0+q*f*cosph0/u)}m=v-sinph0*Math.sin(o);if(m!=0||t!=0){b=Math.atan2(t*f*cosph0,m*u)}break;case this.N_POLE:q=-q;case this.S_POLE:if(Math.abs(u)<=Proj4js.common.EPSLN){o=this.phi0}else{o=Math.asin(this.mode==this.S_POLE?-v:v)}b=(t==0&&q==0)?0:Math.atan2(t,q);break}}else{r=Math.sqrt(t*t+q*q);switch(this.mode){case this.OBLIQ:case this.EQUIT:s=2*Math.atan2(r*this.cosX1,this.akm1);h=Math.cos(s);a=Math.sin(s);if(r==0){e=Math.asin(h*this.sinX1)}else{e=Math.asin(h*this.sinX1+(q*a*this.cosX1/r))}s=Math.tan(0.5*(Proj4js.common.HALF_PI+e));t*=a;q=r*this.cosX1*h-q*this.sinX1*a;l=Proj4js.common.HALF_PI;g=0.5*this.e;break;case this.N_POLE:q=-q;case this.S_POLE:s=-r/this.akm1;e=Proj4js.common.HALF_PI-2*Math.atan(s);l=-Proj4js.common.HALF_PI;g=-0.5*this.e;break}for(j=this.NITER;j--;e=o){a=this.e*Math.sin(e);o=2*Math.atan(s*Math.pow((1+a)/(1-a),g))-l;if(Math.abs(e-o)<this.CONV){if(this.mode==this.S_POLE){o=-o}b=(t==0&&q==0)?0:Math.atan2(t,q);d.x=b;d.y=o;return d}}}}};Proj4js.Proj.nzmg={iterations:1,init:function(){this.A=new Array();this.A[1]=+0.6399175073;this.A[2]=-0.1358797613;this.A[3]=+0.063294409;this.A[4]=-0.02526853;this.A[5]=+0.0117879;this.A[6]=-0.0055161;this.A[7]=+0.0026906;this.A[8]=-0.001333;this.A[9]=+0.00067;this.A[10]=-0.00034;this.B_re=new Array();this.B_im=new Array();this.B_re[1]=+0.7557853228;this.B_im[1]=0;this.B_re[2]=+0.249204646;this.B_im[2]=+0.003371507;this.B_re[3]=-0.001541739;this.B_im[3]=+0.04105856;this.B_re[4]=-0.10162907;this.B_im[4]=+0.01727609;this.B_re[5]=-0.26623489;this.B_im[5]=-0.36249218;this.B_re[6]=-0.6870983;this.B_im[6]=-1.1651967;this.C_re=new Array();this.C_im=new Array();this.C_re[1]=+1.3231270439;this.C_im[1]=0;this.C_re[2]=-0.577245789;this.C_im[2]=-0.007809598;this.C_re[3]=+0.508307513;this.C_im[3]=-0.112208952;this.C_re[4]=-0.15094762;this.C_im[4]=+0.18200602;this.C_re[5]=+1.01418179;this.C_im[5]=+1.64497696;this.C_re[6]=+1.9660549;this.C_im[6]=+2.5127645;this.D=new Array();this.D[1]=+1.5627014243;this.D[2]=+0.5185406398;this.D[3]=-0.03333098;this.D[4]=-0.1052906;this.D[5]=-0.0368594;this.D[6]=+0.007317;this.D[7]=+0.0122;this.D[8]=+0.00394;this.D[9]=-0.0013},forward:function(d){var b=d.x;var s=d.y;var v=s-this.lat0;var l=b-this.long0;var e=v/Proj4js.common.SEC_TO_RAD*0.00001;var a=l;var o=1;var j=0;for(n=1;n<=10;n++){o=o*e;j=j+this.A[n]*o}var m=j;var g=a;var q=1;var h=0;var u;var f;var t=0;var r=0;for(n=1;n<=6;n++){u=q*m-h*g;f=h*m+q*g;q=u;h=f;t=t+this.B_re[n]*q-this.B_im[n]*h;r=r+this.B_im[n]*q+this.B_re[n]*h}x=(r*this.a)+this.x0;y=(t*this.a)+this.y0;d.x=x;d.y=y;return d},inverse:function(w){var t=w.x;var s=w.y;var D=t-this.x0;var C=s-this.y0;var r=C/this.a;var f=D/this.a;var l=1;var J=0;var g;var G;var m=0;var a=0;for(n=1;n<=6;n++){g=l*r-J*f;G=J*r+l*f;l=g;J=G;m=m+this.C_re[n]*l-this.C_im[n]*J;a=a+this.C_im[n]*l+this.C_re[n]*J}for(i=0;i<this.iterations;i++){var u=m;var j=a;var B;var v;var d=r;var F=f;for(n=2;n<=6;n++){B=u*m-j*a;v=j*m+u*a;u=B;j=v;d=d+(n-1)*(this.B_re[n]*u-this.B_im[n]*j);F=F+(n-1)*(this.B_im[n]*u+this.B_re[n]*j)}u=1;j=0;var b=this.B_re[1];var E=this.B_im[1];for(n=2;n<=6;n++){B=u*m-j*a;v=j*m+u*a;u=B;j=v;b=b+n*(this.B_re[n]*u-this.B_im[n]*j);E=E+n*(this.B_im[n]*u+this.B_re[n]*j)}var e=b*b+E*E;m=(d*b+F*E)/e;a=(F*b-d*E)/e}var z=m;var q=a;var H=1;var I=0;for(n=1;n<=9;n++){H=H*z;I=I+this.D[n]*H}var o=this.lat0+(I*Proj4js.common.SEC_TO_RAD*100000);var h=this.long0+q;w.x=h;w.y=o;return w}};Proj4js.Proj.mill={init:function(){},forward:function(d){var e=d.x;var b=d.y;dlon=Proj4js.common.adjust_lon(e-this.long0);var a=this.x0+this.a*dlon;var f=this.y0+this.a*Math.log(Math.tan((Proj4js.common.PI/4)+(b/2.5)))*1.25;d.x=a;d.y=f;return d},inverse:function(b){b.x-=this.x0;b.y-=this.y0;var d=Proj4js.common.adjust_lon(this.long0+b.x/this.a);var a=2.5*(Math.atan(Math.exp(0.8*b.y/this.a))-Proj4js.common.PI/4);b.x=d;b.y=a;return b}};Proj4js.Proj.sinu={init:function(){this.R=6370997},forward:function(e){var a,g,b;var f=e.x;var d=e.y;b=Proj4js.common.adjust_lon(f-this.long0);a=this.R*b*Math.cos(d)+this.x0;g=this.R*d+this.y0;e.x=a;e.y=g;return e},inverse:function(d){var b,a,e;d.x-=this.x0;d.y-=this.y0;b=d.y/this.R;if(Math.abs(b)>Proj4js.common.HALF_PI){Proj4js.reportError("sinu:Inv:DataError")}a=Math.abs(b)-Proj4js.common.HALF_PI;if(Math.abs(a)>Proj4js.common.EPSLN){a=this.long0+d.x/(this.R*Math.cos(b));e=Proj4js.common.adjust_lon(a)}else{e=this.long0}d.x=e;d.y=b;return d}};var GEOCENT_LAT_ERROR=1;var COS_67P5=0.3826834323650898;var AD_C=1.0026;function cs_geodetic_to_geocentric(o,d){var r=d.x;var j=d.y;var e=d.z;var f;var b;var a;var m=0;var q;var l;var h;var g;if(j<-HALF_PI&&j>-1.001*HALF_PI){j=-HALF_PI}else{if(j>HALF_PI&&j<1.001*HALF_PI){j=HALF_PI}else{if((j<-HALF_PI)||(j>HALF_PI)){m|=GEOCENT_LAT_ERROR}}}if(!m){if(r>PI){r-=(2*PI)}l=Math.sin(j);g=Math.cos(j);h=l*l;q=o.a/(Math.sqrt(1-o.es*h));f=(q+e)*g*Math.cos(r);b=(q+e)*g*Math.sin(r);a=((q*(1-o.es))+e)*l}d.x=f;d.y=b;d.z=a;return m}function cs_geocentric_to_geodetic(o,z){var e=z.x;var d=z.y;var a=z.z;var h;var w;var r;var f;var t;var v;var s;var m;var j;var l;var D;var g;var C;var B;var u;var q;var b;e=parseFloat(e);d=parseFloat(d);a=parseFloat(a);b=false;if(e!=0){h=Math.atan2(d,e)}else{if(d>0){h=HALF_PI}else{if(d<0){h=-HALF_PI}else{b=true;h=0;if(a>0){w=HALF_PI}else{if(a<0){w=-HALF_PI}else{w=HALF_PI;r=-o.b;return}}}}}t=e*e+d*d;f=Math.sqrt(t);v=a*AD_C;m=Math.sqrt(v*v+t);l=v/m;g=f/m;D=l*l*l;s=a+o.b*o.ep2*D;q=f-o.a*o.es*g*g*g;j=Math.sqrt(s*s+q*q);C=s/j;B=q/j;u=o.a/Math.sqrt(1-o.es*C*C);if(B>=COS_67P5){r=f/B-u}else{if(B<=-COS_67P5){r=f/-B-u}else{r=a/C+u*(o.es-1)}}if(b==false){w=Math.atan(C/B)}z.x=h;z.y=w;z.z=r;return 0}function cs_geocentric_to_wgs84(j,b){if(j.datum_type==PJD_3PARAM){b.x+=j.datum_params[0];b.y+=j.datum_params[1];b.z+=j.datum_params[2]}else{var g=j.datum_params[0];var e=j.datum_params[1];var m=j.datum_params[2];var f=j.datum_params[3];var o=j.datum_params[4];var l=j.datum_params[5];var h=j.datum_params[6];var d=h*(b.x-l*b.y+o*b.z)+g;var a=h*(l*b.x+b.y-f*b.z)+e;var q=h*(-o*b.x+f*b.y+b.z)+m;b.x=d;b.y=a;b.z=q}}function cs_geocentric_from_wgs84(l,d){if(l.datum_type==PJD_3PARAM){d.x-=l.datum_params[0];d.y-=l.datum_params[1];d.z-=l.datum_params[2]}else{var h=l.datum_params[0];var e=l.datum_params[1];var o=l.datum_params[2];var g=l.datum_params[3];var q=l.datum_params[4];var m=l.datum_params[5];var j=l.datum_params[6];var f=(d.x-h)/j;var b=(d.y-e)/j;var a=(d.z-o)/j;d.x=f+m*b-q*a;d.y=-m*f+b+g*a;d.z=q*f-g*b+a}}Proj4js.Proj.vandg={init:function(){this.R=6370997},forward:function(d){var a=d.x;var s=d.y;var w=Proj4js.common.adjust_lon(a-this.long0);var v,t;if(Math.abs(s)<=Proj4js.common.EPSLN){v=this.x0+this.R*w;t=this.y0}var f=Proj4js.common.asinz(2*Math.abs(s/Proj4js.common.PI));if((Math.abs(w)<=Proj4js.common.EPSLN)||(Math.abs(Math.abs(s)-Proj4js.common.HALF_PI)<=Proj4js.common.EPSLN)){v=this.x0;if(s>=0){t=this.y0+Proj4js.common.PI*this.R*Math.tan(0.5*f)}else{t=this.y0+Proj4js.common.PI*this.R*-Math.tan(0.5*f)}}var q=0.5*Math.abs((Proj4js.common.PI/w)-(w/Proj4js.common.PI));var e=q*q;var r=Math.sin(f);var o=Math.cos(f);var l=o/(r+o-1);var j=l*l;var h=l*(2/r-1);var u=h*h;var b=Proj4js.common.PI*this.R*(q*(l-u)+Math.sqrt(e*(l-u)*(l-u)-(u+e)*(j-u)))/(u+e);if(w<0){b=-b}v=this.x0+b;b=Math.abs(b/(Proj4js.common.PI*this.R));if(s>=0){t=this.y0+Proj4js.common.PI*this.R*Math.sqrt(1-b*b-2*q*b)}else{t=this.y0-Proj4js.common.PI*this.R*Math.sqrt(1-b*b-2*q*b)}d.x=v;d.y=t;return d},inverse:function(f){var u;var a,q,t,l,j,h;var m,g;var e;var s;var b;var r;var o;f.x-=this.x0;f.y-=this.y0;b=Proj4js.common.PI*this.R;a=f.x/b;q=f.y/b;t=a*a+q*q;l=-Math.abs(q)*(1+t);j=l-2*q*q+a*a;h=-2*l+1+2*q*q+t*t;o=q*q/h+(2*j*j*j/h/h/h-9*l*j/h/h)/27;e=(l-j*j/3/h)/h;s=2*Math.sqrt(-e/3);b=((3*o)/e)/s;if(Math.abs(b)>1){if(b>=0){b=1}else{b=-1}}r=Math.acos(b)/3;if(f.y>=0){lat=(-s*Math.cos(r+Proj4js.common.PI/3)-j/3/h)*Proj4js.common.PI}else{lat=-(-s*Math.cos(r+PI/3)-j/3/h)*Proj4js.common.PI}if(Math.abs(a)<Proj4js.common.EPSLN){lon=this.long0}lon=Proj4js.common.adjust_lon(this.long0+Proj4js.common.PI*(t-1+Math.sqrt(1+2*(a*a-q*q)+t*t))/2/a);f.x=lon;f.y=lat;return f}};Proj4js.Proj.eqc={init:function(){if(!this.x0){this.x0=0}if(!this.y0){this.y0=0}if(!this.lat0){this.lat0=0}if(!this.long0){this.long0=0}if(!this.lat_ts){this.lat_ts=0}if(!this.title){this.title="Equidistant Cylindrical (Plate Carre)"}this.rc=Math.cos(this.lat_ts)},forward:function(e){var f=e.x;var d=e.y;var b=Proj4js.common.adjust_lon(f-this.long0);var a=Proj4js.common.adjust_lat(d-this.lat0);e.x=this.x0+(this.a*b*this.rc);e.y=this.y0+(this.a*a);return e},inverse:function(b){var a=b.x;var d=b.y;b.x=Proj4js.common.adjust_lon(this.long0+((a-this.x0)/(this.a*this.rc)));b.y=Proj4js.common.adjust_lat(this.lat0+((d-this.y0)/(this.a)));return b}};Proj4js.Proj.gauss={init:function(){sphi=Math.sin(this.lat0);cphi=Math.cos(this.lat0);cphi*=cphi;this.rc=Math.sqrt(1-this.es)/(1-this.es*sphi*sphi);this.C=Math.sqrt(1+this.es*cphi*cphi/(1-this.es));this.phic0=Math.asin(sphi/this.C);this.ratexp=0.5*this.C*this.e;this.K=Math.tan(0.5*this.phic0+Proj4js.common.FORTPI)/(Math.pow(Math.tan(0.5*this.lat0+Proj4js.common.FORTPI),this.C)*Proj4js.common.srat(this.e*sphi,this.ratexp))},forward:function(b){var d=b.x;var a=b.y;b.y=2*Math.atan(this.K*Math.pow(Math.tan(0.5*a+Proj4js.common.FORTPI),this.C)*Proj4js.common.srat(this.e*Math.sin(a),this.ratexp))-Proj4js.common.HALF_PI;b.x=this.C*d;return b},inverse:function(e){var d=1e-14;var f=e.x/this.C;var b=e.y;num=Math.pow(Math.tan(0.5*b+Proj4js.common.FORTPI)/this.K,1/this.C);for(var a=Proj4js.common.MAX_ITER;a>0;--a){b=2*Math.atan(num*Proj4js.common.srat(this.e*Math.sin(e.y),-0.5*this.e))-Proj4js.common.HALF_PI;if(Math.abs(b-e.y)<d){break}e.y=b}if(!a){Proj4js.reportError("gauss:inverse:convergence failed");return null}e.x=f;e.y=b;return e}};Proj4js.Proj.omerc={init:function(){if(!this.mode){this.mode=0}if(!this.lon1){this.lon1=0;this.mode=1}if(!this.lon2){this.lon2=0}if(!this.lat2){this.lat2=0}var a=this.b/this.a;var d=1-Math.pow(a,2);var b=Math.sqrt(d);this.sin_p20=Math.sin(this.lat0);this.cos_p20=Math.cos(this.lat0);this.con=1-this.es*this.sin_p20*this.sin_p20;this.com=Math.sqrt(1-d);this.bl=Math.sqrt(1+this.es*Math.pow(this.cos_p20,4)/(1-d));this.al=this.a*this.bl*this.k0*this.com/this.con;if(Math.abs(this.lat0)<Proj4js.common.EPSLN){this.ts=1;this.d=1;this.el=1}else{this.ts=Proj4js.common.tsfnz(this.e,this.lat0,this.sin_p20);this.con=Math.sqrt(this.con);this.d=this.bl*this.com/(this.cos_p20*this.con);if((this.d*this.d-1)>0){if(this.lat0>=0){this.f=this.d+Math.sqrt(this.d*this.d-1)}else{this.f=this.d-Math.sqrt(this.d*this.d-1)}}else{this.f=this.d}this.el=this.f*Math.pow(this.ts,this.bl)}if(this.mode!=0){this.g=0.5*(this.f-1/this.f);this.gama=Proj4js.common.asinz(Math.sin(this.alpha)/this.d);this.longc=this.longc-Proj4js.common.asinz(this.g*Math.tan(this.gama))/this.bl;this.con=Math.abs(this.lat0);if((this.con>Proj4js.common.EPSLN)&&(Math.abs(this.con-Proj4js.common.HALF_PI)>Proj4js.common.EPSLN)){this.singam=Math.sin(this.gama);this.cosgam=Math.cos(this.gama);this.sinaz=Math.sin(this.alpha);this.cosaz=Math.cos(this.alpha);if(this.lat0>=0){this.u=(this.al/this.bl)*Math.atan(Math.sqrt(this.d*this.d-1)/this.cosaz)}else{this.u=-(this.al/this.bl)*Math.atan(Math.sqrt(this.d*this.d-1)/this.cosaz)}}else{Proj4js.reportError("omerc:Init:DataError")}}else{this.sinphi=Math.sin(this.at1);this.ts1=Proj4js.common.tsfnz(this.e,this.lat1,this.sinphi);this.sinphi=Math.sin(this.lat2);this.ts2=Proj4js.common.tsfnz(this.e,this.lat2,this.sinphi);this.h=Math.pow(this.ts1,this.bl);this.l=Math.pow(this.ts2,this.bl);this.f=this.el/this.h;this.g=0.5*(this.f-1/this.f);this.j=(this.el*this.el-this.l*this.h)/(this.el*this.el+this.l*this.h);this.p=(this.l-this.h)/(this.l+this.h);this.dlon=this.lon1-this.lon2;if(this.dlon<-Proj4js.common.PI){this.lon2=this.lon2-2*Proj4js.common.PI}if(this.dlon>Proj4js.common.PI){this.lon2=this.lon2+2*Proj4js.common.PI}this.dlon=this.lon1-this.lon2;this.longc=0.5*(this.lon1+this.lon2)-Math.atan(this.j*Math.tan(0.5*this.bl*this.dlon)/this.p)/this.bl;this.dlon=Proj4js.common.adjust_lon(this.lon1-this.longc);this.gama=Math.atan(Math.sin(this.bl*this.dlon)/this.g);this.alpha=Proj4js.common.asinz(this.d*Math.sin(this.gama));if(Math.abs(this.lat1-this.lat2)<=Proj4js.common.EPSLN){Proj4js.reportError("omercInitDataError")}else{this.con=Math.abs(this.lat1)}if((this.con<=Proj4js.common.EPSLN)||(Math.abs(this.con-HALF_PI)<=Proj4js.common.EPSLN)){Proj4js.reportError("omercInitDataError")}else{if(Math.abs(Math.abs(this.lat0)-Proj4js.common.HALF_PI)<=Proj4js.common.EPSLN){Proj4js.reportError("omercInitDataError")}}this.singam=Math.sin(this.gam);this.cosgam=Math.cos(this.gam);this.sinaz=Math.sin(this.alpha);this.cosaz=Math.cos(this.alpha);if(this.lat0>=0){this.u=(this.al/this.bl)*Math.atan(Math.sqrt(this.d*this.d-1)/this.cosaz)}else{this.u=-(this.al/this.bl)*Math.atan(Math.sqrt(this.d*this.d-1)/this.cosaz)}}},forward:function(B){var l;var e,I;var H;var G,u,d;var g,C,E;var z,m,F;var v,D;var w;var a;var h;var f=B.x;var j=B.y;e=Math.sin(j);a=Proj4js.common.adjust_lon(f-this.longc);F=Math.sin(this.bl*a);if(Math.abs(Math.abs(j)-Proj4js.common.HALF_PI)>Proj4js.common.EPSLN){h=Proj4js.common.tsfnz(this.e,j,e);z=this.el/(Math.pow(h,this.bl));w=0.5*(z-1/z);u=0.5*(z+1/z);v=(w*this.singam-F*this.cosgam)/u;g=Math.cos(this.bl*a);if(Math.abs(g)<1e-7){m=this.al*this.bl*a}else{m=this.al*Math.atan((w*this.cosgam+F*this.singam)/g)/this.bl;if(g<0){m=m+Proj4js.common.PI*this.al/this.bl}}}else{if(j>=0){v=this.singam}else{v=-this.singam}m=this.al*j/this.bl}if(Math.abs(Math.abs(v)-1)<=Proj4js.common.EPSLN){Proj4js.reportError("omercFwdInfinity")}D=0.5*this.al*Math.log((1-v)/(1+v))/this.bl;m=m-this.u;var r=this.x0+D*this.cosaz+m*this.sinaz;var o=this.y0+m*this.cosaz-D*this.sinaz;B.x=r;B.y=o;return B},inverse:function(v){var I;var j;var f;var e,H;var G;var E,o,d;var g,w,C;var z,l,u,r,h;var D,m,F;var a;var B;v.x-=this.x0;v.y-=this.y0;B=0;z=v.x*this.cosaz-v.y*this.sinaz;l=v.y*this.cosaz+v.x*this.sinaz;l=l+this.u;u=Math.exp(-this.bl*z/this.al);r=0.5*(u-1/u);o=0.5*(u+1/u);D=Math.sin(this.bl*l/this.al);m=(D*this.cosgam+r*this.singam)/o;if(Math.abs(Math.abs(m)-1)<=Proj4js.common.EPSLN){lon=this.longc;if(m>=0){lat=Proj4js.common.HALF_PI}else{lat=-Proj4js.common.HALF_PI}}else{g=1/this.bl;h=Math.pow((this.el/Math.sqrt((1+m)/(1-m))),g);lat=Proj4js.common.phi2z(this.e,h);j=this.longc-Math.atan2((r*this.cosgam-D*this.singam),g)/this.bl;lon=Proj4js.common.adjust_lon(j)}v.x=lon;v.y=lat;return v}};Proj4js.Proj.lcc={init:function(){if(!this.lat2){this.lat2=this.lat0}if(!this.k0){this.k0=1}if(Math.abs(this.lat1+this.lat2)<Proj4js.common.EPSLN){Proj4js.reportError("lcc:init: Equal Latitudes");return}var m=this.b/this.a;this.e=Math.sqrt(1-m*m);var h=Math.sin(this.lat1);var f=Math.cos(this.lat1);var l=Proj4js.common.msfnz(this.e,h,f);var b=Proj4js.common.tsfnz(this.e,this.lat1,h);var g=Math.sin(this.lat2);var e=Math.cos(this.lat2);var j=Proj4js.common.msfnz(this.e,g,e);var a=Proj4js.common.tsfnz(this.e,this.lat2,g);var d=Proj4js.common.tsfnz(this.e,this.lat0,Math.sin(this.lat0));if(Math.abs(this.lat1-this.lat2)>Proj4js.common.EPSLN){this.ns=Math.log(l/j)/Math.log(b/a)}else{this.ns=h}this.f0=l/(this.ns*Math.pow(b,this.ns));this.rh=this.a*this.f0*Math.pow(d,this.ns);if(!this.title){this.title="Lambert Conformal Conic"}},forward:function(f){var g=f.x;var e=f.y;if(e<=90&&e>=-90&&g<=180&&g>=-180){}else{Proj4js.reportError("lcc:forward: llInputOutOfRange: "+g+" : "+e);return null}var a=Math.abs(Math.abs(e)-Proj4js.common.HALF_PI);var d;if(a>Proj4js.common.EPSLN){d=Proj4js.common.tsfnz(this.e,e,Math.sin(e));rh1=this.a*this.f0*Math.pow(d,this.ns)}else{a=e*this.ns;if(a<=0){Proj4js.reportError("lcc:forward: No Projection");return null}rh1=0}var b=this.ns*Proj4js.common.adjust_lon(g-this.long0);f.x=this.k0*(rh1*Math.sin(b))+this.x0;f.y=this.k0*(this.rh-rh1*Math.cos(b))+this.y0;return f},inverse:function(f){var h,a,d;var e,g;x=(f.x-this.x0)/this.k0;y=(this.rh-(f.y-this.y0)/this.k0);if(this.ns>0){h=Math.sqrt(x*x+y*y);a=1}else{h=-Math.sqrt(x*x+y*y);a=-1}var b=0;if(h!=0){b=Math.atan2((a*x),(a*y))}if((h!=0)||(this.ns>0)){a=1/this.ns;d=Math.pow((h/(this.a*this.f0)),a);e=Proj4js.common.phi2z(this.e,d);if(e==-9999){return null}}else{e=-Proj4js.common.HALF_PI}g=Proj4js.common.adjust_lon(b/this.ns+this.long0);f.x=g;f.y=e;return f}};Proj4js.Proj.laea={init:function(){this.sin_lat_o=Math.sin(this.lat0);this.cos_lat_o=Math.cos(this.lat0)},forward:function(b){var a=b.x;var l=b.y;var f=Proj4js.common.adjust_lon(a-this.long0);var r=Math.sin(l);var m=Math.cos(l);var d=Math.sin(f);var e=Math.cos(f);var j=this.sin_lat_o*r+this.cos_lat_o*m*e;if(j==-1){Proj4js.reportError("laea:fwd:Point projects to a circle of radius "+2*R);return null}var h=this.a*Math.sqrt(2/(1+j));var q=h*m*d+this.x0;var o=h*(this.cos_lat_o*r-this.sin_lat_o*m*e)+this.y0;b.x=q;b.y=o;return b},inverse:function(g){g.x-=this.x0;g.y-=this.y0;var e=Math.sqrt(g.x*g.x+g.y*g.y);var d=e/(2*this.a);if(d>1){Proj4js.reportError("laea:Inv:DataError");return null}var j=2*Proj4js.common.asinz(d);var b=Math.sin(j);var a=Math.cos(j);var h=this.long0;if(Math.abs(e)>Proj4js.common.EPSLN){var f=Proj4js.common.asinz(this.sin_lat_o*a+this.cos_lat_o*b*g.y/e);var d=Math.abs(this.lat0)-Proj4js.common.HALF_PI;if(Math.abs(d)>Proj4js.common.EPSLN){d=a-this.sin_lat_o*Math.sin(f);if(d!=0){h=Proj4js.common.adjust_lon(this.long0+Math.atan2(g.x*b*this.cos_lat_o,d*e))}}else{if(this.lat0<0){h=Proj4js.common.adjust_lon(this.long0-Math.atan2(-g.x,g.y))}else{h=Proj4js.common.adjust_lon(this.long0+Math.atan2(g.x,-g.y))}}}else{f=this.lat0}g.x=h;g.y=f;return g}};Proj4js.Proj.aeqd={init:function(){this.sin_p12=Math.sin(this.lat0);this.cos_p12=Math.cos(this.lat0)},forward:function(d){var b=d.x;var l=d.y;var f;var a=Math.sin(d.y);var e=Math.cos(d.y);var o=Proj4js.common.adjust_lon(b-this.long0);var m=Math.cos(o);var h=this.sin_p12*a+this.cos_p12*e*m;if(Math.abs(Math.abs(h)-1)<Proj4js.common.EPSLN){f=1;if(h<0){Proj4js.reportError("aeqd:Fwd:PointError");return}}else{var j=Math.acos(h);f=j/Math.sin(j)}d.x=this.x0+this.a*f*e*Math.sin(o);d.y=this.y0+this.a*f*(this.cos_p12*a-this.sin_p12*e*m);return d},inverse:function(b){b.x-=this.x0;b.y-=this.y0;var h=Math.sqrt(b.x*b.x+b.y*b.y);if(h>(2*Proj4js.common.HALF_PI*this.a)){Proj4js.reportError("aeqdInvDataError");return}var f=h/this.a;var e=Math.sin(f);var l=Math.cos(f);var a=this.long0;var g;if(Math.abs(h)<=Proj4js.common.EPSLN){g=this.lat0}else{g=Proj4js.common.asinz(l*this.sin_p12+(b.y*e*this.cos_p12)/h);var d=Math.abs(this.lat0)-Proj4js.common.HALF_PI;if(Math.abs(d)<=Proj4js.common.EPSLN){if(lat0>=0){a=Proj4js.common.adjust_lon(this.long0+Math.atan2(b.x,-b.y))}else{a=Proj4js.common.adjust_lon(this.long0-Math.atan2(-b.x,b.y))}}else{d=l-this.sin_p12*Math.sin(g);if((Math.abs(d)<Proj4js.common.EPSLN)&&(Math.abs(b.x)<Proj4js.common.EPSLN)){}else{var j=Math.atan2((b.x*e*this.cos_p12),(d*h));a=Proj4js.common.adjust_lon(this.long0+Math.atan2((b.x*e*this.cos_p12),(d*h)))}}}b.x=a;b.y=g;return b}};Proj4js.Proj.moll={init:function(){},forward:function(d){var a=d.x;var j=d.y;var g=Proj4js.common.adjust_lon(a-this.long0);var f=j;var e=Proj4js.common.PI*Math.sin(j);for(var h=0;;h++){var b=-(f+Math.sin(f)-e)/(1+Math.cos(f));f+=b;if(Math.abs(b)<Proj4js.common.EPSLN){break}if(h>=50){Proj4js.reportError("moll:Fwd:IterationError")}}f/=2;if(Proj4js.common.PI/2-Math.abs(j)<Proj4js.common.EPSLN){g=0}var m=0.900316316158*this.a*g*Math.cos(f)+this.x0;var l=1.4142135623731*this.a*Math.sin(f)+this.y0;d.x=m;d.y=l;return d},inverse:function(e){var b;var a;e.x-=this.x0;var a=e.y/(1.4142135623731*this.a);if(Math.abs(a)>0.999999999999){a=0.999999999999}var b=Math.asin(a);var f=Proj4js.common.adjust_lon(this.long0+(e.x/(0.900316316158*this.a*Math.cos(b))));if(f<(-Proj4js.common.PI)){f=-Proj4js.common.PI}if(f>Proj4js.common.PI){f=Proj4js.common.PI}a=(2*b+Math.sin(2*b))/Proj4js.common.PI;if(Math.abs(a)>1){a=1}var d=Math.asin(a);e.x=f;e.y=d;return e}};